package org.yiwan.seiya.tower.logistics.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 快递公司
 */
@ApiModel(description = "快递公司")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-12T19:08:02.829+08:00")
public class ExpressCompanyResponse   {
    @JsonProperty("expressName")
    private String expressName = null;

    @JsonProperty("expressCode")
    private String expressCode = null;

    @JsonProperty("trackable")
    private Boolean trackable = null;

    @JsonProperty("eorderable")
    private Boolean eorderable = null;

    @JsonProperty("orderable")
    private Boolean orderable = null;

    public ExpressCompanyResponse withExpressName(String expressName) {
        this.expressName = expressName;
        return this;
    }

    /**
    * 快递公司名称
    * @return expressName
    **/
    @ApiModelProperty(example = "顺丰速运", value = "快递公司名称")


    public String getExpressName() {
        return expressName;
    }

    public void setExpressName(String expressName) {
        this.expressName = expressName;
    }

    public ExpressCompanyResponse withExpressCode(String expressCode) {
        this.expressCode = expressCode;
        return this;
    }

    /**
    * 快递公司编码
    * @return expressCode
    **/
    @ApiModelProperty(example = "SF", value = "快递公司编码")


    public String getExpressCode() {
        return expressCode;
    }

    public void setExpressCode(String expressCode) {
        this.expressCode = expressCode;
    }

    public ExpressCompanyResponse withTrackable(Boolean trackable) {
        this.trackable = trackable;
        return this;
    }

    /**
    * 支持轨迹查询
    * @return trackable
    **/
    @ApiModelProperty(example = "false", value = "支持轨迹查询")


    public Boolean isgetTrackable() {
        return trackable;
    }

    public void setTrackable(Boolean trackable) {
        this.trackable = trackable;
    }

    public ExpressCompanyResponse withEorderable(Boolean eorderable) {
        this.eorderable = eorderable;
        return this;
    }

    /**
    * 支持电子面单
    * @return eorderable
    **/
    @ApiModelProperty(example = "false", value = "支持电子面单")


    public Boolean isgetEorderable() {
        return eorderable;
    }

    public void setEorderable(Boolean eorderable) {
        this.eorderable = eorderable;
    }

    public ExpressCompanyResponse withOrderable(Boolean orderable) {
        this.orderable = orderable;
        return this;
    }

    /**
    * 支持预约取件
    * @return orderable
    **/
    @ApiModelProperty(example = "false", value = "支持预约取件")


    public Boolean isgetOrderable() {
        return orderable;
    }

    public void setOrderable(Boolean orderable) {
        this.orderable = orderable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExpressCompanyResponse expressCompanyResponse = (ExpressCompanyResponse) o;
        return Objects.equals(this.expressName, expressCompanyResponse.expressName) &&
            Objects.equals(this.expressCode, expressCompanyResponse.expressCode) &&
            Objects.equals(this.trackable, expressCompanyResponse.trackable) &&
            Objects.equals(this.eorderable, expressCompanyResponse.eorderable) &&
            Objects.equals(this.orderable, expressCompanyResponse.orderable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(expressName, expressCode, trackable, eorderable, orderable);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link ExpressCompanyResponse }.
     */
    public static ExpressCompanyResponse fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, ExpressCompanyResponse.class);
    }
}

