package org.yiwan.seiya.tower.logistics.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 电子面单下单返回
 */
@ApiModel(description = "电子面单下单返回")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-12T19:08:02.829+08:00")
public class OrderResponse   {
    @JsonProperty("orderCode")
    private String orderCode = null;

    @JsonProperty("expressCode")
    private String expressCode = null;

    @JsonProperty("logisticCode")
    private String logisticCode = null;

    @JsonProperty("printTemplate")
    private String printTemplate = null;

    @JsonProperty("estimatedDeliveryTime")
    private OffsetDateTime estimatedDeliveryTime = null;

    public OrderResponse withOrderCode(String orderCode) {
        this.orderCode = orderCode;
        return this;
    }

    /**
    * 订单编号
    * @return orderCode
    **/
    @ApiModelProperty(example = "PYT2019090800001", value = "订单编号")


    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public OrderResponse withExpressCode(String expressCode) {
        this.expressCode = expressCode;
        return this;
    }

    /**
    * 快递公司编码
    * @return expressCode
    **/
    @ApiModelProperty(example = "SF", value = "快递公司编码")


    public String getExpressCode() {
        return expressCode;
    }

    public void setExpressCode(String expressCode) {
        this.expressCode = expressCode;
    }

    public OrderResponse withLogisticCode(String logisticCode) {
        this.logisticCode = logisticCode;
        return this;
    }

    /**
    * 快递单号
    * @return logisticCode
    **/
    @ApiModelProperty(example = "SF1011327874518", value = "快递单号")


    public String getLogisticCode() {
        return logisticCode;
    }

    public void setLogisticCode(String logisticCode) {
        this.logisticCode = logisticCode;
    }

    public OrderResponse withPrintTemplate(String printTemplate) {
        this.printTemplate = printTemplate;
        return this;
    }

    /**
    * 面单打印模板内容(html格式)
    * @return printTemplate
    **/
    @ApiModelProperty(value = "面单打印模板内容(html格式)")


    public String getPrintTemplate() {
        return printTemplate;
    }

    public void setPrintTemplate(String printTemplate) {
        this.printTemplate = printTemplate;
    }

    public OrderResponse withEstimatedDeliveryTime(OffsetDateTime estimatedDeliveryTime) {
        this.estimatedDeliveryTime = estimatedDeliveryTime;
        return this;
    }

    /**
    * 订单预计到货时间yyyy-mm-dd
    * @return estimatedDeliveryTime
    **/
    @ApiModelProperty(example = "2019-09-10", value = "订单预计到货时间yyyy-mm-dd")

  @Valid

    public OffsetDateTime getEstimatedDeliveryTime() {
        return estimatedDeliveryTime;
    }

    public void setEstimatedDeliveryTime(OffsetDateTime estimatedDeliveryTime) {
        this.estimatedDeliveryTime = estimatedDeliveryTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrderResponse orderResponse = (OrderResponse) o;
        return Objects.equals(this.orderCode, orderResponse.orderCode) &&
            Objects.equals(this.expressCode, orderResponse.expressCode) &&
            Objects.equals(this.logisticCode, orderResponse.logisticCode) &&
            Objects.equals(this.printTemplate, orderResponse.printTemplate) &&
            Objects.equals(this.estimatedDeliveryTime, orderResponse.estimatedDeliveryTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orderCode, expressCode, logisticCode, printTemplate, estimatedDeliveryTime);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link OrderResponse }.
     */
    public static OrderResponse fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, OrderResponse.class);
    }
}

