package org.yiwan.seiya.tower.logistics.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.yiwan.seiya.tower.logistics.model.TrackVO;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 物流轨迹返回
 */
@ApiModel(description = "物流轨迹返回")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-12T19:08:02.829+08:00")
public class TrackResponse   {
    @JsonProperty("orderCode")
    private String orderCode = null;

    @JsonProperty("expressCode")
    private String expressCode = null;

    @JsonProperty("logisticCode")
    private String logisticCode = null;

    @JsonProperty("traces")
    @Valid
    private List<TrackVO> traces = null;

    public TrackResponse withOrderCode(String orderCode) {
        this.orderCode = orderCode;
        return this;
    }

    /**
    * 订单编号
    * @return orderCode
    **/
    @ApiModelProperty(example = "PYT2019090800001", value = "订单编号")


    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public TrackResponse withExpressCode(String expressCode) {
        this.expressCode = expressCode;
        return this;
    }

    /**
    * 快递公司编码
    * @return expressCode
    **/
    @ApiModelProperty(example = "SF", value = "快递公司编码")


    public String getExpressCode() {
        return expressCode;
    }

    public void setExpressCode(String expressCode) {
        this.expressCode = expressCode;
    }

    public TrackResponse withLogisticCode(String logisticCode) {
        this.logisticCode = logisticCode;
        return this;
    }

    /**
    * 快递单号
    * @return logisticCode
    **/
    @ApiModelProperty(example = "SF1011327874518", value = "快递单号")


    public String getLogisticCode() {
        return logisticCode;
    }

    public void setLogisticCode(String logisticCode) {
        this.logisticCode = logisticCode;
    }

    public TrackResponse withTraces(List<TrackVO> traces) {
        this.traces = traces;
        return this;
    }

    public TrackResponse withTracesAdd(TrackVO traces) {
        if (this.traces == null) {
            this.traces = new ArrayList<TrackVO>();
        }
        this.traces.add(traces);
        return this;
    }

    /**
    * 物流信息
    * @return traces
    **/
    @ApiModelProperty(value = "物流信息")

  @Valid

    public List<TrackVO> getTraces() {
        return traces;
    }

    public void setTraces(List<TrackVO> traces) {
        this.traces = traces;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TrackResponse trackResponse = (TrackResponse) o;
        return Objects.equals(this.orderCode, trackResponse.orderCode) &&
            Objects.equals(this.expressCode, trackResponse.expressCode) &&
            Objects.equals(this.logisticCode, trackResponse.logisticCode) &&
            Objects.equals(this.traces, trackResponse.traces);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orderCode, expressCode, logisticCode, traces);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link TrackResponse }.
     */
    public static TrackResponse fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, TrackResponse.class);
    }
}

