package org.yiwan.seiya.tower.logistics.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 预约取件请求
 */
@ApiModel(description = "预约取件请求")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-12T19:08:02.829+08:00")
public class OrderBookingReq   {
    @JsonProperty("expressCode")
    private String expressCode = null;

    @JsonProperty("orderCode")
    private String orderCode = null;

    @JsonProperty("payType")
    private Integer payType = null;

    @JsonProperty("monthCode")
    private String monthCode = null;

    @JsonProperty("receiverName")
    private String receiverName = null;

    @JsonProperty("receiverTel")
    private String receiverTel = null;

    @JsonProperty("receiverPostCode")
    private String receiverPostCode = null;

    @JsonProperty("receiverProvince")
    private String receiverProvince = null;

    @JsonProperty("receiverCity")
    private String receiverCity = null;

    @JsonProperty("receiverDistrict")
    private String receiverDistrict = null;

    @JsonProperty("receiverAddress")
    private String receiverAddress = null;

    @JsonProperty("senderName")
    private String senderName = null;

    @JsonProperty("senderPostCode")
    private String senderPostCode = null;

    @JsonProperty("senderTel")
    private String senderTel = null;

    @JsonProperty("senderProvince")
    private String senderProvince = null;

    @JsonProperty("senderCity")
    private String senderCity = null;

    @JsonProperty("senderDistrict")
    private String senderDistrict = null;

    @JsonProperty("senderAddress")
    private String senderAddress = null;

    @JsonProperty("collectStartTime")
    private OffsetDateTime collectStartTime = null;

    @JsonProperty("collectEndTime")
    private OffsetDateTime collectEndTime = null;

    @JsonProperty("quantity")
    private Integer quantity = null;

    @JsonProperty("volume")
    private Integer volume = null;

    @JsonProperty("goodsName")
    private String goodsName = null;

    @JsonProperty("remark")
    private String remark = null;

    public OrderBookingReq withExpressCode(String expressCode) {
        this.expressCode = expressCode;
        return this;
    }

    /**
    * 快递公司编码
    * @return expressCode
    **/
    @ApiModelProperty(example = "SF", required = true, value = "快递公司编码")
  @NotNull


    public String getExpressCode() {
        return expressCode;
    }

    public void setExpressCode(String expressCode) {
        this.expressCode = expressCode;
    }

    public OrderBookingReq withOrderCode(String orderCode) {
        this.orderCode = orderCode;
        return this;
    }

    /**
    * 订单编号
    * @return orderCode
    **/
    @ApiModelProperty(example = "201909050001", required = true, value = "订单编号")
  @NotNull


    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public OrderBookingReq withPayType(Integer payType) {
        this.payType = payType;
        return this;
    }

    /**
    * 运费支付方式(1.现付 2.到付 3.月结)
    * @return payType
    **/
    @ApiModelProperty(example = "1", required = true, value = "运费支付方式(1.现付 2.到付 3.月结)")
  @NotNull


    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public OrderBookingReq withMonthCode(String monthCode) {
        this.monthCode = monthCode;
        return this;
    }

    /**
    * 月结卡号(payType=3 时必填)
    * @return monthCode
    **/
    @ApiModelProperty(example = "SF8866998", value = "月结卡号(payType=3 时必填)")


    public String getMonthCode() {
        return monthCode;
    }

    public void setMonthCode(String monthCode) {
        this.monthCode = monthCode;
    }

    public OrderBookingReq withReceiverName(String receiverName) {
        this.receiverName = receiverName;
        return this;
    }

    /**
    * 收件人姓名
    * @return receiverName
    **/
    @ApiModelProperty(example = "李小勇", required = true, value = "收件人姓名")
  @NotNull


    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public OrderBookingReq withReceiverTel(String receiverTel) {
        this.receiverTel = receiverTel;
        return this;
    }

    /**
    * 收件人电话
    * @return receiverTel
    **/
    @ApiModelProperty(example = "13774392605", required = true, value = "收件人电话")
  @NotNull


    public String getReceiverTel() {
        return receiverTel;
    }

    public void setReceiverTel(String receiverTel) {
        this.receiverTel = receiverTel;
    }

    public OrderBookingReq withReceiverPostCode(String receiverPostCode) {
        this.receiverPostCode = receiverPostCode;
        return this;
    }

    /**
    * 收件人邮编(ShipperCode 为EMS、YZPY、YZBK 时必填)
    * @return receiverPostCode
    **/
    @ApiModelProperty(example = "450003", value = "收件人邮编(ShipperCode 为EMS、YZPY、YZBK 时必填)")


    public String getReceiverPostCode() {
        return receiverPostCode;
    }

    public void setReceiverPostCode(String receiverPostCode) {
        this.receiverPostCode = receiverPostCode;
    }

    public OrderBookingReq withReceiverProvince(String receiverProvince) {
        this.receiverProvince = receiverProvince;
        return this;
    }

    /**
    * 收件省
    * @return receiverProvince
    **/
    @ApiModelProperty(example = "河南省", required = true, value = "收件省")
  @NotNull


    public String getReceiverProvince() {
        return receiverProvince;
    }

    public void setReceiverProvince(String receiverProvince) {
        this.receiverProvince = receiverProvince;
    }

    public OrderBookingReq withReceiverCity(String receiverCity) {
        this.receiverCity = receiverCity;
        return this;
    }

    /**
    * 收件市
    * @return receiverCity
    **/
    @ApiModelProperty(example = "郑州市", required = true, value = "收件市")
  @NotNull


    public String getReceiverCity() {
        return receiverCity;
    }

    public void setReceiverCity(String receiverCity) {
        this.receiverCity = receiverCity;
    }

    public OrderBookingReq withReceiverDistrict(String receiverDistrict) {
        this.receiverDistrict = receiverDistrict;
        return this;
    }

    /**
    * 收件区/县
    * @return receiverDistrict
    **/
    @ApiModelProperty(example = "金水区", required = true, value = "收件区/县")
  @NotNull


    public String getReceiverDistrict() {
        return receiverDistrict;
    }

    public void setReceiverDistrict(String receiverDistrict) {
        this.receiverDistrict = receiverDistrict;
    }

    public OrderBookingReq withReceiverAddress(String receiverAddress) {
        this.receiverAddress = receiverAddress;
        return this;
    }

    /**
    * 收件详细地址
    * @return receiverAddress
    **/
    @ApiModelProperty(example = "商都路188号101室", required = true, value = "收件详细地址")
  @NotNull


    public String getReceiverAddress() {
        return receiverAddress;
    }

    public void setReceiverAddress(String receiverAddress) {
        this.receiverAddress = receiverAddress;
    }

    public OrderBookingReq withSenderName(String senderName) {
        this.senderName = senderName;
        return this;
    }

    /**
    * 发件人姓名
    * @return senderName
    **/
    @ApiModelProperty(example = "王大强", required = true, value = "发件人姓名")
  @NotNull


    public String getSenderName() {
        return senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public OrderBookingReq withSenderPostCode(String senderPostCode) {
        this.senderPostCode = senderPostCode;
        return this;
    }

    /**
    * 发件人邮编(ShipperCode 为EMS、YZPY、YZBK 时必填)
    * @return senderPostCode
    **/
    @ApiModelProperty(example = "201908", value = "发件人邮编(ShipperCode 为EMS、YZPY、YZBK 时必填)")


    public String getSenderPostCode() {
        return senderPostCode;
    }

    public void setSenderPostCode(String senderPostCode) {
        this.senderPostCode = senderPostCode;
    }

    public OrderBookingReq withSenderTel(String senderTel) {
        this.senderTel = senderTel;
        return this;
    }

    /**
    * 发件人电话
    * @return senderTel
    **/
    @ApiModelProperty(example = "13512345678", required = true, value = "发件人电话")
  @NotNull


    public String getSenderTel() {
        return senderTel;
    }

    public void setSenderTel(String senderTel) {
        this.senderTel = senderTel;
    }

    public OrderBookingReq withSenderProvince(String senderProvince) {
        this.senderProvince = senderProvince;
        return this;
    }

    /**
    * 发件省
    * @return senderProvince
    **/
    @ApiModelProperty(example = "上海", required = true, value = "发件省")
  @NotNull


    public String getSenderProvince() {
        return senderProvince;
    }

    public void setSenderProvince(String senderProvince) {
        this.senderProvince = senderProvince;
    }

    public OrderBookingReq withSenderCity(String senderCity) {
        this.senderCity = senderCity;
        return this;
    }

    /**
    * 发件市
    * @return senderCity
    **/
    @ApiModelProperty(example = "上海市", required = true, value = "发件市")
  @NotNull


    public String getSenderCity() {
        return senderCity;
    }

    public void setSenderCity(String senderCity) {
        this.senderCity = senderCity;
    }

    public OrderBookingReq withSenderDistrict(String senderDistrict) {
        this.senderDistrict = senderDistrict;
        return this;
    }

    /**
    * 发件区/县
    * @return senderDistrict
    **/
    @ApiModelProperty(example = "宝山区", required = true, value = "发件区/县")
  @NotNull


    public String getSenderDistrict() {
        return senderDistrict;
    }

    public void setSenderDistrict(String senderDistrict) {
        this.senderDistrict = senderDistrict;
    }

    public OrderBookingReq withSenderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
        return this;
    }

    /**
    * 发件详细地址
    * @return senderAddress
    **/
    @ApiModelProperty(example = "富南路199弄101室", required = true, value = "发件详细地址")
  @NotNull


    public String getSenderAddress() {
        return senderAddress;
    }

    public void setSenderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
    }

    public OrderBookingReq withCollectStartTime(OffsetDateTime collectStartTime) {
        this.collectStartTime = collectStartTime;
        return this;
    }

    /**
    * 揽件开始时间(yyyy-MM-dd HH:mm:ss)
    * @return collectStartTime
    **/
    @ApiModelProperty(example = "2019-09-26 15:18:07", value = "揽件开始时间(yyyy-MM-dd HH:mm:ss)")

  @Valid

    public OffsetDateTime getCollectStartTime() {
        return collectStartTime;
    }

    public void setCollectStartTime(OffsetDateTime collectStartTime) {
        this.collectStartTime = collectStartTime;
    }

    public OrderBookingReq withCollectEndTime(OffsetDateTime collectEndTime) {
        this.collectEndTime = collectEndTime;
        return this;
    }

    /**
    * 揽件结束时间(yyyy-MM-dd HH:mm:ss)
    * @return collectEndTime
    **/
    @ApiModelProperty(example = "2019-09-26 19:18:07", value = "揽件结束时间(yyyy-MM-dd HH:mm:ss)")

  @Valid

    public OffsetDateTime getCollectEndTime() {
        return collectEndTime;
    }

    public void setCollectEndTime(OffsetDateTime collectEndTime) {
        this.collectEndTime = collectEndTime;
    }

    public OrderBookingReq withQuantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    /**
    * 数量
    * @return quantity
    **/
    @ApiModelProperty(example = "1", value = "数量")


    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public OrderBookingReq withVolume(Integer volume) {
        this.volume = volume;
        return this;
    }

    /**
    * 体积
    * @return volume
    **/
    @ApiModelProperty(example = "0", value = "体积")


    public Integer getVolume() {
        return volume;
    }

    public void setVolume(Integer volume) {
        this.volume = volume;
    }

    public OrderBookingReq withGoodsName(String goodsName) {
        this.goodsName = goodsName;
        return this;
    }

    /**
    * 商品名称
    * @return goodsName
    **/
    @ApiModelProperty(example = "发票", value = "商品名称")


    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public OrderBookingReq withRemark(String remark) {
        this.remark = remark;
        return this;
    }

    /**
    * 备注
    * @return remark
    **/
    @ApiModelProperty(value = "备注")


    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrderBookingReq orderBookingReq = (OrderBookingReq) o;
        return Objects.equals(this.expressCode, orderBookingReq.expressCode) &&
            Objects.equals(this.orderCode, orderBookingReq.orderCode) &&
            Objects.equals(this.payType, orderBookingReq.payType) &&
            Objects.equals(this.monthCode, orderBookingReq.monthCode) &&
            Objects.equals(this.receiverName, orderBookingReq.receiverName) &&
            Objects.equals(this.receiverTel, orderBookingReq.receiverTel) &&
            Objects.equals(this.receiverPostCode, orderBookingReq.receiverPostCode) &&
            Objects.equals(this.receiverProvince, orderBookingReq.receiverProvince) &&
            Objects.equals(this.receiverCity, orderBookingReq.receiverCity) &&
            Objects.equals(this.receiverDistrict, orderBookingReq.receiverDistrict) &&
            Objects.equals(this.receiverAddress, orderBookingReq.receiverAddress) &&
            Objects.equals(this.senderName, orderBookingReq.senderName) &&
            Objects.equals(this.senderPostCode, orderBookingReq.senderPostCode) &&
            Objects.equals(this.senderTel, orderBookingReq.senderTel) &&
            Objects.equals(this.senderProvince, orderBookingReq.senderProvince) &&
            Objects.equals(this.senderCity, orderBookingReq.senderCity) &&
            Objects.equals(this.senderDistrict, orderBookingReq.senderDistrict) &&
            Objects.equals(this.senderAddress, orderBookingReq.senderAddress) &&
            Objects.equals(this.collectStartTime, orderBookingReq.collectStartTime) &&
            Objects.equals(this.collectEndTime, orderBookingReq.collectEndTime) &&
            Objects.equals(this.quantity, orderBookingReq.quantity) &&
            Objects.equals(this.volume, orderBookingReq.volume) &&
            Objects.equals(this.goodsName, orderBookingReq.goodsName) &&
            Objects.equals(this.remark, orderBookingReq.remark);
    }

    @Override
    public int hashCode() {
        return Objects.hash(expressCode, orderCode, payType, monthCode, receiverName, receiverTel, receiverPostCode, receiverProvince, receiverCity, receiverDistrict, receiverAddress, senderName, senderPostCode, senderTel, senderProvince, senderCity, senderDistrict, senderAddress, collectStartTime, collectEndTime, quantity, volume, goodsName, remark);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link OrderBookingReq }.
     */
    public static OrderBookingReq fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, OrderBookingReq.class);
    }
}

