package org.yiwan.seiya.tower.logistics.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 预约下单返回
 */
@ApiModel(description = "预约下单返回")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-12T19:08:02.829+08:00")
public class OrderBookingResponse   {
    @JsonProperty("orderCode")
    private String orderCode = null;

    @JsonProperty("expressCode")
    private String expressCode = null;

    @JsonProperty("logisticCode")
    private String logisticCode = null;

    public OrderBookingResponse withOrderCode(String orderCode) {
        this.orderCode = orderCode;
        return this;
    }

    /**
    * 订单编号
    * @return orderCode
    **/
    @ApiModelProperty(example = "PYT2019090800001", value = "订单编号")


    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public OrderBookingResponse withExpressCode(String expressCode) {
        this.expressCode = expressCode;
        return this;
    }

    /**
    * 快递公司编码
    * @return expressCode
    **/
    @ApiModelProperty(example = "SF", value = "快递公司编码")


    public String getExpressCode() {
        return expressCode;
    }

    public void setExpressCode(String expressCode) {
        this.expressCode = expressCode;
    }

    public OrderBookingResponse withLogisticCode(String logisticCode) {
        this.logisticCode = logisticCode;
        return this;
    }

    /**
    * 快递单号
    * @return logisticCode
    **/
    @ApiModelProperty(example = "SF1011327874518", value = "快递单号")


    public String getLogisticCode() {
        return logisticCode;
    }

    public void setLogisticCode(String logisticCode) {
        this.logisticCode = logisticCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrderBookingResponse orderBookingResponse = (OrderBookingResponse) o;
        return Objects.equals(this.orderCode, orderBookingResponse.orderCode) &&
            Objects.equals(this.expressCode, orderBookingResponse.expressCode) &&
            Objects.equals(this.logisticCode, orderBookingResponse.logisticCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orderCode, expressCode, logisticCode);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link OrderBookingResponse }.
     */
    public static OrderBookingResponse fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, OrderBookingResponse.class);
    }
}

