package org.yiwan.seiya.tower.logistics.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 轨迹订阅返回
 */
@ApiModel(description = "轨迹订阅返回")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-12T19:08:02.829+08:00")
public class TrackSubscriptionResp   {
    @JsonProperty("estimatedDeliveryTime")
    private OffsetDateTime estimatedDeliveryTime = null;

    @JsonProperty("updateTime")
    private OffsetDateTime updateTime = null;

    public TrackSubscriptionResp withEstimatedDeliveryTime(OffsetDateTime estimatedDeliveryTime) {
        this.estimatedDeliveryTime = estimatedDeliveryTime;
        return this;
    }

    /**
    * 订单预计到货时间yyyy-mm-dd
    * @return estimatedDeliveryTime
    **/
    @ApiModelProperty(example = "2019-09-12", value = "订单预计到货时间yyyy-mm-dd")

  @Valid

    public OffsetDateTime getEstimatedDeliveryTime() {
        return estimatedDeliveryTime;
    }

    public void setEstimatedDeliveryTime(OffsetDateTime estimatedDeliveryTime) {
        this.estimatedDeliveryTime = estimatedDeliveryTime;
    }

    public TrackSubscriptionResp withUpdateTime(OffsetDateTime updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    /**
    * 更新时间
    * @return updateTime
    **/
    @ApiModelProperty(example = "2019-09-10 10:20:30", value = "更新时间")

  @Valid

    public OffsetDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(OffsetDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TrackSubscriptionResp trackSubscriptionResp = (TrackSubscriptionResp) o;
        return Objects.equals(this.estimatedDeliveryTime, trackSubscriptionResp.estimatedDeliveryTime) &&
            Objects.equals(this.updateTime, trackSubscriptionResp.updateTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(estimatedDeliveryTime, updateTime);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link TrackSubscriptionResp }.
     */
    public static TrackSubscriptionResp fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, TrackSubscriptionResp.class);
    }
}

