package org.yiwan.seiya.tower.logistics.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 物流轨迹
 */
@ApiModel(description = "物流轨迹")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-12T19:08:02.829+08:00")
public class TrackVO   {
    @JsonProperty("acceptTime")
    private OffsetDateTime acceptTime = null;

    @JsonProperty("acceptStation")
    private String acceptStation = null;

    @JsonProperty("remark")
    private String remark = null;

    public TrackVO withAcceptTime(OffsetDateTime acceptTime) {
        this.acceptTime = acceptTime;
        return this;
    }

    /**
    * 接收时间
    * @return acceptTime
    **/
    @ApiModelProperty(example = "2018-10-26 18:31:38", required = true, value = "接收时间")
  @NotNull

  @Valid

    public OffsetDateTime getAcceptTime() {
        return acceptTime;
    }

    public void setAcceptTime(OffsetDateTime acceptTime) {
        this.acceptTime = acceptTime;
    }

    public TrackVO withAcceptStation(String acceptStation) {
        this.acceptStation = acceptStation;
        return this;
    }

    /**
    * 接收信息
    * @return acceptStation
    **/
    @ApiModelProperty(example = "【宝山站】的【票易通】已收件", required = true, value = "接收信息")
  @NotNull


    public String getAcceptStation() {
        return acceptStation;
    }

    public void setAcceptStation(String acceptStation) {
        this.acceptStation = acceptStation;
    }

    public TrackVO withRemark(String remark) {
        this.remark = remark;
        return this;
    }

    /**
    * 备注
    * @return remark
    **/
    @ApiModelProperty(value = "备注")


    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TrackVO trackVO = (TrackVO) o;
        return Objects.equals(this.acceptTime, trackVO.acceptTime) &&
            Objects.equals(this.acceptStation, trackVO.acceptStation) &&
            Objects.equals(this.remark, trackVO.remark);
    }

    @Override
    public int hashCode() {
        return Objects.hash(acceptTime, acceptStation, remark);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link TrackVO }.
     */
    public static TrackVO fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, TrackVO.class);
    }
}

