package org.yiwan.seiya.tower.message.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.yiwan.seiya.tower.message.model.EmailAttachment;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * EmailContentReq
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-08-19T01:33:11.057+08:00")
public class EmailContentReq   {
    @JsonProperty("attachments")
    @Valid
    private List<EmailAttachment> attachments = null;

    @JsonProperty("content")
    private String content = null;

    @JsonProperty("email")
    private String email = null;

    @JsonProperty("subject")
    private String subject = null;

    public EmailContentReq withAttachments(List<EmailAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public EmailContentReq withAttachmentsAdd(EmailAttachment attachments) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<EmailAttachment>();
        }
        this.attachments.add(attachments);
        return this;
    }

    /**
    * 附件列表
    * @return attachments
    **/
    @ApiModelProperty(value = "附件列表")

  @Valid

    public List<EmailAttachment> getAttachments() {
        return attachments;
    }

    public void setAttachments(List<EmailAttachment> attachments) {
        this.attachments = attachments;
    }

    public EmailContentReq withContent(String content) {
        this.content = content;
        return this;
    }

    /**
    * 邮件内容
    * @return content
    **/
    @ApiModelProperty(example = "测试内容", value = "邮件内容")


    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public EmailContentReq withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
    * 邮箱账号
    * @return email
    **/
    @ApiModelProperty(example = "yours@sina.com", value = "邮箱账号")


    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public EmailContentReq withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    /**
    * 邮件主题
    * @return subject
    **/
    @ApiModelProperty(example = "票易通验证码", value = "邮件主题")


    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmailContentReq emailContentReq = (EmailContentReq) o;
        return Objects.equals(this.attachments, emailContentReq.attachments) &&
            Objects.equals(this.content, emailContentReq.content) &&
            Objects.equals(this.email, emailContentReq.email) &&
            Objects.equals(this.subject, emailContentReq.subject);
    }

    @Override
    public int hashCode() {
        return Objects.hash(attachments, content, email, subject);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link EmailContentReq }.
     */
    public static EmailContentReq fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, EmailContentReq.class);
    }
}

