package org.yiwan.seiya.tower.message.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * EmailValidateReq
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-08-19T01:33:11.057+08:00")
public class EmailValidateReq   {
    @JsonProperty("code")
    private String code = null;

    @JsonProperty("email")
    private String email = null;

    @JsonProperty("msgId")
    private String msgId = null;

    public EmailValidateReq withCode(String code) {
        this.code = code;
        return this;
    }

    /**
    * 验证码
    * @return code
    **/
    @ApiModelProperty(example = "123456", value = "验证码")


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public EmailValidateReq withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
    * 邮箱账号
    * @return email
    **/
    @ApiModelProperty(example = "1831716675", value = "邮箱账号")


    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public EmailValidateReq withMsgId(String msgId) {
        this.msgId = msgId;
        return this;
    }

    /**
    * 消息ID
    * @return msgId
    **/
    @ApiModelProperty(example = "a1111111111", value = "消息ID")


    public String getMsgId() {
        return msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmailValidateReq emailValidateReq = (EmailValidateReq) o;
        return Objects.equals(this.code, emailValidateReq.code) &&
            Objects.equals(this.email, emailValidateReq.email) &&
            Objects.equals(this.msgId, emailValidateReq.msgId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, email, msgId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link EmailValidateReq }.
     */
    public static EmailValidateReq fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, EmailValidateReq.class);
    }
}

