package org.yiwan.seiya.tower.message.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * SmsValidateReq
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-08-26T01:01:36.590+08:00")
public class SmsValidateReq   {
    @JsonProperty("code")
    private String code = null;

    @JsonProperty("mobile")
    private String mobile = null;

    @JsonProperty("msgId")
    private String msgId = null;

    public SmsValidateReq withCode(String code) {
        this.code = code;
        return this;
    }

    /**
    * 验证码
    * @return code
    **/
    @ApiModelProperty(example = "123456", value = "验证码")


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public SmsValidateReq withMobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    /**
    * 手机号码
    * @return mobile
    **/
    @ApiModelProperty(example = "1831716675", value = "手机号码")


    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public SmsValidateReq withMsgId(String msgId) {
        this.msgId = msgId;
        return this;
    }

    /**
    * 消息ID
    * @return msgId
    **/
    @ApiModelProperty(example = "a1111111111", value = "消息ID")


    public String getMsgId() {
        return msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SmsValidateReq smsValidateReq = (SmsValidateReq) o;
        return Objects.equals(this.code, smsValidateReq.code) &&
            Objects.equals(this.mobile, smsValidateReq.mobile) &&
            Objects.equals(this.msgId, smsValidateReq.msgId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, mobile, msgId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link SmsValidateReq }.
     */
    public static SmsValidateReq fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, SmsValidateReq.class);
    }
}

