package org.yiwan.seiya.tower.message.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * EmailAttachment
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-09-16T01:01:21.995+08:00")
public class EmailAttachment   {
    @JsonProperty("displayName")
    private String displayName = null;

    @JsonProperty("fileUrl")
    private String fileUrl = null;

    public EmailAttachment withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
    * 附件名称
    * @return displayName
    **/
    @ApiModelProperty(example = "附件名称", value = "附件名称")


    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public EmailAttachment withFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
        return this;
    }

    /**
    * 附件路径
    * @return fileUrl
    **/
    @ApiModelProperty(example = "http://xxx.jpg", value = "附件路径")


    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmailAttachment emailAttachment = (EmailAttachment) o;
        return Objects.equals(this.displayName, emailAttachment.displayName) &&
            Objects.equals(this.fileUrl, emailAttachment.fileUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(displayName, fileUrl);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link EmailAttachment }.
     */
    public static EmailAttachment fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, EmailAttachment.class);
    }
}

