package org.yiwan.seiya.tower.message.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * EmailTemplateReq
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-09-16T01:01:21.995+08:00")
public class EmailTemplateReq   {
    @JsonProperty("appId")
    private Long appId = null;

    @JsonProperty("id")
    private Long id = null;

    @JsonProperty("senderName")
    private String senderName = null;

    @JsonProperty("subject")
    private String subject = null;

    @JsonProperty("templateCode")
    private String templateCode = null;

    @JsonProperty("templateContent")
    private String templateContent = null;

    @JsonProperty("templateName")
    private String templateName = null;

    @JsonProperty("templateType")
    private Integer templateType = null;

    public EmailTemplateReq withAppId(Long appId) {
        this.appId = appId;
        return this;
    }

    /**
    * 产品线Id
    * @return appId
    **/
    @ApiModelProperty(value = "产品线Id")


    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public EmailTemplateReq withId(Long id) {
        this.id = id;
        return this;
    }

    /**
    * 模板id
    * @return id
    **/
    @ApiModelProperty(value = "模板id")


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EmailTemplateReq withSenderName(String senderName) {
        this.senderName = senderName;
        return this;
    }

    /**
    * 模板内容
    * @return senderName
    **/
    @ApiModelProperty(value = "模板内容")


    public String getSenderName() {
        return senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public EmailTemplateReq withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    /**
    * 邮件标题
    * @return subject
    **/
    @ApiModelProperty(value = "邮件标题")


    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public EmailTemplateReq withTemplateCode(String templateCode) {
        this.templateCode = templateCode;
        return this;
    }

    /**
    * 模板code
    * @return templateCode
    **/
    @ApiModelProperty(value = "模板code")


    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public EmailTemplateReq withTemplateContent(String templateContent) {
        this.templateContent = templateContent;
        return this;
    }

    /**
    * 发送人名称
    * @return templateContent
    **/
    @ApiModelProperty(value = "发送人名称")


    public String getTemplateContent() {
        return templateContent;
    }

    public void setTemplateContent(String templateContent) {
        this.templateContent = templateContent;
    }

    public EmailTemplateReq withTemplateName(String templateName) {
        this.templateName = templateName;
        return this;
    }

    /**
    * 模板名称
    * @return templateName
    **/
    @ApiModelProperty(value = "模板名称")


    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public EmailTemplateReq withTemplateType(Integer templateType) {
        this.templateType = templateType;
        return this;
    }

    /**
    * 模板类型
    * @return templateType
    **/
    @ApiModelProperty(value = "模板类型")


    public Integer getTemplateType() {
        return templateType;
    }

    public void setTemplateType(Integer templateType) {
        this.templateType = templateType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmailTemplateReq emailTemplateReq = (EmailTemplateReq) o;
        return Objects.equals(this.appId, emailTemplateReq.appId) &&
            Objects.equals(this.id, emailTemplateReq.id) &&
            Objects.equals(this.senderName, emailTemplateReq.senderName) &&
            Objects.equals(this.subject, emailTemplateReq.subject) &&
            Objects.equals(this.templateCode, emailTemplateReq.templateCode) &&
            Objects.equals(this.templateContent, emailTemplateReq.templateContent) &&
            Objects.equals(this.templateName, emailTemplateReq.templateName) &&
            Objects.equals(this.templateType, emailTemplateReq.templateType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appId, id, senderName, subject, templateCode, templateContent, templateName, templateType);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link EmailTemplateReq }.
     */
    public static EmailTemplateReq fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, EmailTemplateReq.class);
    }
}

