package org.yiwan.seiya.tower.message.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * SmsMessageReq
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-09-16T01:01:21.995+08:00")
public class SmsMessageReq   {
    @JsonProperty("extno")
    private String extno = null;

    @JsonProperty("mobile")
    private String mobile = null;

    @JsonProperty("signName")
    private String signName = null;

    @JsonProperty("templateCode")
    private String templateCode = null;

    @JsonProperty("templateParamJson")
    private String templateParamJson = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    public SmsMessageReq withExtno(String extno) {
        this.extno = extno;
        return this;
    }

    /**
    * 扩展参数
    * @return extno
    **/
    @ApiModelProperty(example = "extno", value = "扩展参数")


    public String getExtno() {
        return extno;
    }

    public void setExtno(String extno) {
        this.extno = extno;
    }

    public SmsMessageReq withMobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    /**
    * 用户账号
    * @return mobile
    **/
    @ApiModelProperty(example = "1831716675", value = "用户账号")


    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public SmsMessageReq withSignName(String signName) {
        this.signName = signName;
        return this;
    }

    /**
    * 签名
    * @return signName
    **/
    @ApiModelProperty(example = "票易通", value = "签名")


    public String getSignName() {
        return signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public SmsMessageReq withTemplateCode(String templateCode) {
        this.templateCode = templateCode;
        return this;
    }

    /**
    * 模板code
    * @return templateCode
    **/
    @ApiModelProperty(example = "123456", value = "模板code")


    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public SmsMessageReq withTemplateParamJson(String templateParamJson) {
        this.templateParamJson = templateParamJson;
        return this;
    }

    /**
    * 模板参数json
    * @return templateParamJson
    **/
    @ApiModelProperty(example = "json", value = "模板参数json")


    public String getTemplateParamJson() {
        return templateParamJson;
    }

    public void setTemplateParamJson(String templateParamJson) {
        this.templateParamJson = templateParamJson;
    }

    public SmsMessageReq withTenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
    * 租户ID
    * @return tenantId
    **/
    @ApiModelProperty(example = "11112222", value = "租户ID")


    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SmsMessageReq smsMessageReq = (SmsMessageReq) o;
        return Objects.equals(this.extno, smsMessageReq.extno) &&
            Objects.equals(this.mobile, smsMessageReq.mobile) &&
            Objects.equals(this.signName, smsMessageReq.signName) &&
            Objects.equals(this.templateCode, smsMessageReq.templateCode) &&
            Objects.equals(this.templateParamJson, smsMessageReq.templateParamJson) &&
            Objects.equals(this.tenantId, smsMessageReq.tenantId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(extno, mobile, signName, templateCode, templateParamJson, tenantId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link SmsMessageReq }.
     */
    public static SmsMessageReq fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, SmsMessageReq.class);
    }
}

