package org.yiwan.seiya.tower.message.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * SmsCodeReq
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-09-25T01:01:36.705+08:00")
public class SmsCodeReq   {
    @JsonProperty("expireTime")
    private Integer expireTime = null;

    @JsonProperty("extno")
    private String extno = null;

    @JsonProperty("mobile")
    private String mobile = null;

    @JsonProperty("signName")
    private String signName = null;

    @JsonProperty("templateCode")
    private String templateCode = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    public SmsCodeReq withExpireTime(Integer expireTime) {
        this.expireTime = expireTime;
        return this;
    }

    /**
    * 过期时间(分)，传值范围是1-30
    * @return expireTime
    **/
    @ApiModelProperty(example = "3", value = "过期时间(分)，传值范围是1-30")


    public Integer getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Integer expireTime) {
        this.expireTime = expireTime;
    }

    public SmsCodeReq withExtno(String extno) {
        this.extno = extno;
        return this;
    }

    /**
    * 扩展参数
    * @return extno
    **/
    @ApiModelProperty(example = "extno", value = "扩展参数")


    public String getExtno() {
        return extno;
    }

    public void setExtno(String extno) {
        this.extno = extno;
    }

    public SmsCodeReq withMobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    /**
    * 用户账号
    * @return mobile
    **/
    @ApiModelProperty(example = "1831716675", value = "用户账号")


    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public SmsCodeReq withSignName(String signName) {
        this.signName = signName;
        return this;
    }

    /**
    * 签名
    * @return signName
    **/
    @ApiModelProperty(example = "票易通", value = "签名")


    public String getSignName() {
        return signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public SmsCodeReq withTemplateCode(String templateCode) {
        this.templateCode = templateCode;
        return this;
    }

    /**
    * 模板code
    * @return templateCode
    **/
    @ApiModelProperty(example = "123456", value = "模板code")


    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public SmsCodeReq withTenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
    * 租户ID
    * @return tenantId
    **/
    @ApiModelProperty(example = "11112222", value = "租户ID")


    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SmsCodeReq smsCodeReq = (SmsCodeReq) o;
        return Objects.equals(this.expireTime, smsCodeReq.expireTime) &&
            Objects.equals(this.extno, smsCodeReq.extno) &&
            Objects.equals(this.mobile, smsCodeReq.mobile) &&
            Objects.equals(this.signName, smsCodeReq.signName) &&
            Objects.equals(this.templateCode, smsCodeReq.templateCode) &&
            Objects.equals(this.tenantId, smsCodeReq.tenantId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(expireTime, extno, mobile, signName, templateCode, tenantId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link SmsCodeReq }.
     */
    public static SmsCodeReq fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, SmsCodeReq.class);
    }
}

