package org.yiwan.seiya.tower.message.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yiwan.seiya.tower.message.model.EmailAttachment;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * EmailContentReq
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-11-02T01:01:40.773+08:00")
public class EmailContentReq   {
    @JsonProperty("appId")
    private Long appId = null;

    @JsonProperty("attachments")
    @Valid
    private List<EmailAttachment> attachments = null;

    @JsonProperty("content")
    private String content = null;

    @JsonProperty("email")
    private String email = null;

    @JsonProperty("id")
    private Long id = null;

    @JsonProperty("props")
    @Valid
    private Map<String, String> props = null;

    @JsonProperty("senderName")
    private String senderName = null;

    @JsonProperty("subject")
    private String subject = null;

    @JsonProperty("templateCode")
    private String templateCode = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    public EmailContentReq withAppId(Long appId) {
        this.appId = appId;
        return this;
    }

    /**
    * 产品线Id
    * @return appId
    **/
    @ApiModelProperty(value = "产品线Id")


    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public EmailContentReq withAttachments(List<EmailAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public EmailContentReq withAttachmentsAdd(EmailAttachment attachments) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<EmailAttachment>();
        }
        this.attachments.add(attachments);
        return this;
    }

    /**
    * 附件列表
    * @return attachments
    **/
    @ApiModelProperty(value = "附件列表")

  @Valid

    public List<EmailAttachment> getAttachments() {
        return attachments;
    }

    public void setAttachments(List<EmailAttachment> attachments) {
        this.attachments = attachments;
    }

    public EmailContentReq withContent(String content) {
        this.content = content;
        return this;
    }

    /**
    * 邮件内容
    * @return content
    **/
    @ApiModelProperty(example = "测试内容", value = "邮件内容")


    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public EmailContentReq withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
    * 邮箱账号
    * @return email
    **/
    @ApiModelProperty(example = "yours@sina.com", value = "邮箱账号")


    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public EmailContentReq withId(Long id) {
        this.id = id;
        return this;
    }

    /**
    * 邮件id-重发用
    * @return id
    **/
    @ApiModelProperty(value = "邮件id-重发用")


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EmailContentReq withProps(Map<String, String> props) {
        this.props = props;
        return this;
    }

    public EmailContentReq withPropsPut(String key, String props) {
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        this.props.put(key, props);
        return this;
    }

    /**
    * 模板参数键值对
    * @return props
    **/
    @ApiModelProperty(value = "模板参数键值对")


    public Map<String, String> getProps() {
        return props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public EmailContentReq withSenderName(String senderName) {
        this.senderName = senderName;
        return this;
    }

    /**
    * 发件人名称
    * @return senderName
    **/
    @ApiModelProperty(value = "发件人名称")


    public String getSenderName() {
        return senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public EmailContentReq withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    /**
    * 邮件主题
    * @return subject
    **/
    @ApiModelProperty(example = "票易通验证码", value = "邮件主题")


    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public EmailContentReq withTemplateCode(String templateCode) {
        this.templateCode = templateCode;
        return this;
    }

    /**
    * 模板code
    * @return templateCode
    **/
    @ApiModelProperty(value = "模板code")


    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public EmailContentReq withTenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
    * 租户id
    * @return tenantId
    **/
    @ApiModelProperty(value = "租户id")


    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmailContentReq emailContentReq = (EmailContentReq) o;
        return Objects.equals(this.appId, emailContentReq.appId) &&
            Objects.equals(this.attachments, emailContentReq.attachments) &&
            Objects.equals(this.content, emailContentReq.content) &&
            Objects.equals(this.email, emailContentReq.email) &&
            Objects.equals(this.id, emailContentReq.id) &&
            Objects.equals(this.props, emailContentReq.props) &&
            Objects.equals(this.senderName, emailContentReq.senderName) &&
            Objects.equals(this.subject, emailContentReq.subject) &&
            Objects.equals(this.templateCode, emailContentReq.templateCode) &&
            Objects.equals(this.tenantId, emailContentReq.tenantId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appId, attachments, content, email, id, props, senderName, subject, templateCode, tenantId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link EmailContentReq }.
     */
    public static EmailContentReq fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, EmailContentReq.class);
    }
}

