package org.yiwan.seiya.tower.message.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * EmailAuthCodeReq
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-11-02T01:01:40.773+08:00")
public class EmailAuthCodeReq   {
    @JsonProperty("appId")
    private Long appId = null;

    @JsonProperty("email")
    private String email = null;

    @JsonProperty("expireTime")
    private Integer expireTime = null;

    @JsonProperty("extno")
    private String extno = null;

    @JsonProperty("templateCode")
    private String templateCode = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    public EmailAuthCodeReq withAppId(Long appId) {
        this.appId = appId;
        return this;
    }

    /**
    * 产品线Id
    * @return appId
    **/
    @ApiModelProperty(value = "产品线Id")


    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public EmailAuthCodeReq withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
    * 邮箱账号
    * @return email
    **/
    @ApiModelProperty(example = "lengmingzh@sina.com", value = "邮箱账号")


    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public EmailAuthCodeReq withExpireTime(Integer expireTime) {
        this.expireTime = expireTime;
        return this;
    }

    /**
    * 过期时间(分)，传值范围是1-30
    * @return expireTime
    **/
    @ApiModelProperty(example = "3", value = "过期时间(分)，传值范围是1-30")


    public Integer getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Integer expireTime) {
        this.expireTime = expireTime;
    }

    public EmailAuthCodeReq withExtno(String extno) {
        this.extno = extno;
        return this;
    }

    /**
    * 扩展参数
    * @return extno
    **/
    @ApiModelProperty(example = "extno", value = "扩展参数")


    public String getExtno() {
        return extno;
    }

    public void setExtno(String extno) {
        this.extno = extno;
    }

    public EmailAuthCodeReq withTemplateCode(String templateCode) {
        this.templateCode = templateCode;
        return this;
    }

    /**
    * 模板code
    * @return templateCode
    **/
    @ApiModelProperty(value = "模板code")


    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public EmailAuthCodeReq withTenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
    * 租户ID
    * @return tenantId
    **/
    @ApiModelProperty(example = "11112222", value = "租户ID")


    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmailAuthCodeReq emailAuthCodeReq = (EmailAuthCodeReq) o;
        return Objects.equals(this.appId, emailAuthCodeReq.appId) &&
            Objects.equals(this.email, emailAuthCodeReq.email) &&
            Objects.equals(this.expireTime, emailAuthCodeReq.expireTime) &&
            Objects.equals(this.extno, emailAuthCodeReq.extno) &&
            Objects.equals(this.templateCode, emailAuthCodeReq.templateCode) &&
            Objects.equals(this.tenantId, emailAuthCodeReq.tenantId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appId, email, expireTime, extno, templateCode, tenantId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link EmailAuthCodeReq }.
     */
    public static EmailAuthCodeReq fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, EmailAuthCodeReq.class);
    }
}

