/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.mybatis.generator.codegen.mybatis3.xmlmapper.elements;

import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.codegen.mybatis3.xmlmapper.elements.AbstractXmlElementGenerator;

public class SeiyaXmlElementGenerator
extends AbstractXmlElementGenerator {
    private static final String BASE_COLUMNS = "Base_Column_List";
    private static final String WHERE_CLAUSE = "WHERE_CLAUSE";
    private static final TextElement SELECT_TEXT = new TextElement("select");
    private static final TextElement DELETE_TEXT = new TextElement("delete");
    private static final TextElement SELECT_COUNT_TEXT = new TextElement("select count(*)");
    private String tableName;
    private TextElement selectText;
    private TextElement deleteText;
    private TextElement countText;
    private XmlElement baseColumns;
    private TextElement fromClause;
    private XmlElement whereClause;

    public void addElements(XmlElement parentElement) {
        this.addWhereClause(parentElement);
        this.baseColumns = new XmlElement("include");
        this.baseColumns.addAttribute(new Attribute("refid", BASE_COLUMNS));
        this.tableName = this.introspectedTable.getFullyQualifiedTableNameAtRuntime();
        this.fromClause = new TextElement("from " + this.tableName);
        this.whereClause = new XmlElement("include");
        this.whereClause.addAttribute(new Attribute("refid", WHERE_CLAUSE));
        this.addDelete(parentElement);
        this.addDeleteAll(parentElement);
        this.addSelectAll(parentElement);
        this.addCount(parentElement);
        this.addSelectOne(parentElement);
        this.addSelect(parentElement);
        this.addSelectPkVals(parentElement);
    }

    private void addWhereClause(XmlElement parentElement) {
        XmlElement sqlElement = new XmlElement("sql");
        sqlElement.addAttribute(new Attribute("id", WHERE_CLAUSE));
        XmlElement whereElement = new XmlElement("where");
        for (IntrospectedColumn introspectedColumn : this.introspectedTable.getAllColumns()) {
            XmlElement ifElement = new XmlElement("if");
            ifElement.addAttribute(new Attribute("test", "null != " + introspectedColumn.getJavaProperty()));
            ifElement.addElement((Element)new TextElement("and " + MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn) + " = " + MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn)));
            whereElement.addElement((Element)ifElement);
        }
        sqlElement.addElement((Element)whereElement);
        parentElement.addElement((Element)sqlElement);
    }

    private void addDelete(XmlElement parentElement) {
        XmlElement xmlElement = new XmlElement("select");
        xmlElement.addAttribute(new Attribute("id", "delete"));
        xmlElement.addAttribute(new Attribute("parameterType", this.introspectedTable.getBaseRecordType()));
        xmlElement.addAttribute(new Attribute("resultType", "java.lang.Integer"));
        xmlElement.addElement((Element)DELETE_TEXT);
        xmlElement.addElement((Element)this.fromClause);
        xmlElement.addElement((Element)this.whereClause);
        parentElement.addElement((Element)xmlElement);
    }

    private void addDeleteAll(XmlElement parentElement) {
        XmlElement xmlElement = new XmlElement("select");
        xmlElement.addAttribute(new Attribute("id", "deleteAll"));
        xmlElement.addAttribute(new Attribute("parameterType", this.introspectedTable.getBaseRecordType()));
        xmlElement.addAttribute(new Attribute("resultType", "java.lang.Integer"));
        xmlElement.addElement((Element)DELETE_TEXT);
        xmlElement.addElement((Element)this.fromClause);
        parentElement.addElement((Element)xmlElement);
    }

    private void addSelectAll(XmlElement parentElement) {
        XmlElement xmlElement = new XmlElement("select");
        xmlElement.addAttribute(new Attribute("id", "selectAll"));
        xmlElement.addAttribute(new Attribute("resultMap", "BaseResultMap"));
        xmlElement.addElement((Element)SELECT_TEXT);
        xmlElement.addElement((Element)this.baseColumns);
        xmlElement.addElement((Element)this.fromClause);
        parentElement.addElement((Element)xmlElement);
    }

    private void addCount(XmlElement parentElement) {
        XmlElement xmlElement = new XmlElement("select");
        xmlElement.addAttribute(new Attribute("id", "count"));
        xmlElement.addAttribute(new Attribute("parameterType", this.introspectedTable.getBaseRecordType()));
        xmlElement.addAttribute(new Attribute("resultType", "java.lang.Integer"));
        xmlElement.addElement((Element)SELECT_COUNT_TEXT);
        xmlElement.addElement((Element)this.fromClause);
        xmlElement.addElement((Element)this.whereClause);
        parentElement.addElement((Element)xmlElement);
    }

    private void addSelectOne(XmlElement parentElement) {
        XmlElement xmlElement = new XmlElement("select");
        xmlElement.addAttribute(new Attribute("id", "selectOne"));
        xmlElement.addAttribute(new Attribute("parameterType", this.introspectedTable.getBaseRecordType()));
        xmlElement.addAttribute(new Attribute("resultMap", "BaseResultMap"));
        xmlElement.addElement((Element)SELECT_TEXT);
        xmlElement.addElement((Element)this.baseColumns);
        xmlElement.addElement((Element)this.fromClause);
        xmlElement.addElement((Element)this.whereClause);
        parentElement.addElement((Element)xmlElement);
    }

    private void addSelect(XmlElement parentElement) {
        XmlElement xmlElement = new XmlElement("select");
        xmlElement.addAttribute(new Attribute("id", "select"));
        xmlElement.addAttribute(new Attribute("parameterType", this.introspectedTable.getBaseRecordType()));
        xmlElement.addAttribute(new Attribute("resultMap", "BaseResultMap"));
        xmlElement.addElement((Element)SELECT_TEXT);
        xmlElement.addElement((Element)this.baseColumns);
        xmlElement.addElement((Element)this.fromClause);
        xmlElement.addElement((Element)this.whereClause);
        parentElement.addElement((Element)xmlElement);
    }

    private void addSelectPkVals(XmlElement parentElement) {
        XmlElement xmlElement = new XmlElement("select");
        xmlElement.addAttribute(new Attribute("id", "selectPkVals"));
        xmlElement.addAttribute(new Attribute("parameterType", this.introspectedTable.getBaseRecordType()));
        xmlElement.addAttribute(new Attribute("resultType", "java.lang.Object"));
        xmlElement.addElement((Element)SELECT_TEXT);
        StringBuilder sb = new StringBuilder();
        boolean and = false;
        for (IntrospectedColumn introspectedColumn : this.introspectedTable.getPrimaryKeyColumns()) {
            sb.setLength(0);
            if (and) {
                sb.append(",");
            } else {
                and = true;
            }
            sb.append(MyBatis3FormattingUtilities.getAliasedEscapedColumnName((IntrospectedColumn)introspectedColumn));
            xmlElement.addElement((Element)new TextElement(sb.toString()));
        }
        xmlElement.addElement((Element)this.fromClause);
        xmlElement.addElement((Element)this.whereClause);
        parentElement.addElement((Element)xmlElement);
    }
}

