/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.mybatis.generator.plugins;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class SeiyaActiveRecordPlugin
extends PluginAdapter {
    private static final String BASE_ENTITY = "org.yiwan.seiya.mybatis.extension.entity.BaseEntity";

    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addSuperInterface(introspectedTable, topLevelClass);
        this.generateAutowiredMapperField(introspectedTable, topLevelClass);
        this.generateActiveRecordMethods(introspectedTable, topLevelClass);
        this.generatePkValMethod(introspectedTable, topLevelClass);
        return true;
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addSuperInterface(introspectedTable, topLevelClass);
        this.generateAutowiredMapperField(introspectedTable, topLevelClass);
        this.generateActiveRecordMethods(introspectedTable, topLevelClass);
        this.generatePkValMethod(introspectedTable, topLevelClass);
        return true;
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addSuperInterface(introspectedTable, topLevelClass);
        this.generateAutowiredMapperField(introspectedTable, topLevelClass);
        this.generateActiveRecordMethods(introspectedTable, topLevelClass);
        this.generatePkValMethod(introspectedTable, topLevelClass);
        return true;
    }

    private void addSuperInterface(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        topLevelClass.addImportedType(BASE_ENTITY);
        FullyQualifiedJavaType superInterface = new FullyQualifiedJavaType(BASE_ENTITY);
        FullyQualifiedJavaType baseRecordType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        superInterface.addTypeArgument(baseRecordType);
        topLevelClass.addSuperInterface(superInterface);
    }

    private void generateAutowiredMapperField(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        String typeShortName = topLevelClass.getType().getShortName();
        topLevelClass.addImportedType("org.springframework.beans.factory.annotation.Autowired");
        String importedMapperType = String.format("%s.%sMapper", this.context.getJavaClientGeneratorConfiguration().getTargetPackage(), typeShortName);
        topLevelClass.addImportedType(importedMapperType);
        Field field = new Field();
        field.setFinal(false);
        field.setName(String.format("%sMapper", StringUtils.uncapitalize((String)typeShortName)));
        field.setStatic(false);
        field.setType(new FullyQualifiedJavaType(String.format("%sMapper", typeShortName)));
        field.setVisibility(JavaVisibility.PRIVATE);
        field.addAnnotation("@Autowired");
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3_DSQL) {
            this.context.getCommentGenerator().addFieldAnnotation(field, introspectedTable, topLevelClass.getImportedTypes());
        } else {
            this.context.getCommentGenerator().addFieldComment(field, introspectedTable);
        }
        topLevelClass.addField(field);
    }

    private void generateActiveRecordMethods(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        this.generateDeleteByPrimaryKey(introspectedTable, topLevelClass);
        this.generateInsert(introspectedTable, topLevelClass);
        this.generateInsertSelective(introspectedTable, topLevelClass);
        this.generateSelectByPrimaryKey(introspectedTable, topLevelClass);
        this.generateUpdateByPrimaryKeySelective(introspectedTable, topLevelClass);
        this.generateUpdateByPrimaryKey(introspectedTable, topLevelClass);
        this.generateDelete(introspectedTable, topLevelClass);
        this.generateCount(introspectedTable, topLevelClass);
        this.generateSelectOne(introspectedTable, topLevelClass);
        this.generateSelect(introspectedTable, topLevelClass);
        this.generaterReplace(introspectedTable, topLevelClass);
        this.generaterReplaceSelective(introspectedTable, topLevelClass);
        this.generateSelectPkVals(introspectedTable, topLevelClass);
    }

    private Method generateActiveRecordMethod(TopLevelClass topLevelClass, IntrospectedTable introspectedTable, FullyQualifiedJavaType returnType, String methodName, String parameters) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(returnType);
        method.setName(methodName);
        if (introspectedTable.isJava5Targeted()) {
            method.addAnnotation("@Override");
        }
        String bodyLine = String.format("return %sMapper.%s(%s);", StringUtils.uncapitalize((String)topLevelClass.getType().getShortName()), methodName, parameters);
        method.addBodyLine(bodyLine);
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3_DSQL) {
            this.context.getCommentGenerator().addGeneralMethodAnnotation(method, introspectedTable, topLevelClass.getImportedTypes());
        } else {
            this.context.getCommentGenerator().addGeneralMethodComment(method, introspectedTable);
        }
        return method;
    }

    private String generateParameters(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        List introspectedColumns = introspectedTable.getPrimaryKeyColumns();
        String parameters = introspectedColumns.stream().map(IntrospectedColumn::getJavaProperty).reduce("", (a, b) -> a + ", " + b);
        return StringUtils.stripStart((String)parameters, (String)",").trim();
    }

    private void generateDeleteByPrimaryKey(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getIntInstance();
        String methodName = "deleteByPrimaryKey";
        String parameters = this.generateParameters(introspectedTable, topLevelClass);
        Method method = this.generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateInsert(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getIntInstance();
        String methodName = "insert";
        String parameters = "this";
        Method method = this.generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateInsertSelective(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getIntInstance();
        String methodName = "insertSelective";
        String paramters = "this";
        Method method = this.generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, paramters);
        topLevelClass.addMethod(method);
    }

    private void generateSelectByPrimaryKey(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        String methodName = "selectByPrimaryKey";
        String parameters = this.generateParameters(introspectedTable, topLevelClass);
        Method method = this.generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateUpdateByPrimaryKeySelective(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getIntInstance();
        String methodName = "updateByPrimaryKeySelective";
        String parameters = "this";
        Method method = this.generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateUpdateByPrimaryKey(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getIntInstance();
        String methodName = "updateByPrimaryKey";
        String parameters = "this";
        Method method = this.generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateDelete(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = new FullyQualifiedJavaType("java.lang.Integer");
        String methodName = "delete";
        String parameters = "this";
        Method method = this.generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateSelectAll(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewListInstance());
        FullyQualifiedJavaType baseRecordType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getNewListInstance();
        returnType.addTypeArgument(baseRecordType);
        String methodName = "selectAll";
        String parameters = "";
        Method method = this.generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateCount(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getIntInstance();
        String methodName = "count";
        String parameters = "this";
        Method method = this.generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateSelectOne(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        String methodName = "selectOne";
        String parameters = "this";
        Method method = this.generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateSelect(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewListInstance());
        FullyQualifiedJavaType baseRecordType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getNewListInstance();
        returnType.addTypeArgument(baseRecordType);
        String methodName = "select";
        String parameters = "this";
        Method method = this.generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generaterReplace(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getIntInstance();
        String methodName = "replace";
        String parameters = "this";
        Method method = this.generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generaterReplaceSelective(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getIntInstance();
        String methodName = "replaceSelective";
        String parameters = "this";
        Method method = this.generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generatePkValMethod(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getObjectInstance();
        String methodName = "pkVal";
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(returnType);
        method.setName(methodName);
        if (introspectedTable.isJava5Targeted()) {
            method.addAnnotation("@Override");
        }
        String bodyLine = String.format("return %s;", this.generateParameters(introspectedTable, topLevelClass));
        method.addBodyLine(bodyLine);
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3_DSQL) {
            this.context.getCommentGenerator().addGeneralMethodAnnotation(method, introspectedTable, topLevelClass.getImportedTypes());
        } else {
            this.context.getCommentGenerator().addGeneralMethodComment(method, introspectedTable);
        }
        topLevelClass.addMethod(method);
    }

    private void generateSelectPkVals(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getNewListInstance();
        returnType.addTypeArgument(FullyQualifiedJavaType.getObjectInstance());
        String methodName = "selectPkVals";
        String parameters = "this";
        Method method = this.generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }
}

