/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.tower.notification.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;

@Validated
public class MessageInfo {
    @JsonProperty(value="appId")
    private Long appId = null;
    @JsonProperty(value="content")
    private String content = null;
    @JsonProperty(value="receiverIds")
    @Valid
    private List<Long> receiverIds = null;
    @JsonProperty(value="scope")
    private ScopeEnum scope = null;
    @JsonProperty(value="senderId")
    private Long senderId = null;
    @JsonProperty(value="tags")
    @Valid
    private List<String> tags = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="url")
    private String url = null;

    public MessageInfo withAppId(Long appId) {
        this.appId = appId;
        return this;
    }

    @ApiModelProperty(value="\u4ea7\u54c1\u7ebfid")
    public Long getAppId() {
        return this.appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public MessageInfo withContent(String content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(value="\u6d88\u606f\u5185\u5bb9")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public MessageInfo withReceiverIds(List<Long> receiverIds) {
        this.receiverIds = receiverIds;
        return this;
    }

    public MessageInfo withReceiverIdsAdd(Long receiverIds) {
        if (this.receiverIds == null) {
            this.receiverIds = new ArrayList<Long>();
        }
        this.receiverIds.add(receiverIds);
        return this;
    }

    @ApiModelProperty(value="\u63a5\u6536\u4ebaid\u5217\u8868, scope=[SINGLE]\u65f6\u5fc5\u586b")
    public List<Long> getReceiverIds() {
        return this.receiverIds;
    }

    public void setReceiverIds(List<Long> receiverIds) {
        this.receiverIds = receiverIds;
    }

    public MessageInfo withScope(ScopeEnum scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(value="\u6d88\u606f\u8303\u56f4\uff0cGLOBAL=\u5168\u5c40\u6d88\u606f\uff0cAPP_GLOBAL=\u4ea7\u54c1\u7ebf\u5185\u6d88\u606f\uff0cSINGLE=\u4e2a\u4eba\u6d88\u606f")
    public ScopeEnum getScope() {
        return this.scope;
    }

    public void setScope(ScopeEnum scope) {
        this.scope = scope;
    }

    public MessageInfo withSenderId(Long senderId) {
        this.senderId = senderId;
        return this;
    }

    @ApiModelProperty(value="\u53d1\u9001\u4ebaid, \u5f53scope=[GLOBAL,APP_GLOBAL]\u65f6\u5fc5\u586b")
    public Long getSenderId() {
        return this.senderId;
    }

    public void setSenderId(Long senderId) {
        this.senderId = senderId;
    }

    public MessageInfo withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public MessageInfo withTagsAdd(String tags) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tags);
        return this;
    }

    @ApiModelProperty(value="\u6807\u7b7e")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public MessageInfo withTitle(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="\u6d88\u606f\u6807\u9898")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public MessageInfo withType(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="\u7c7b\u578b, 0 \u7cfb\u7edf\u6d88\u606f 1 \u4e1a\u52a1\u6d88\u606f 2 \u7528\u6237\u6d88\u606f")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public MessageInfo withUrl(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="\u9644\u4ef6\u4e0b\u8f7d\u94fe\u63a5")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageInfo messageInfo = (MessageInfo)o;
        return Objects.equals(this.appId, messageInfo.appId) && Objects.equals(this.content, messageInfo.content) && Objects.equals(this.receiverIds, messageInfo.receiverIds) && Objects.equals((Object)this.scope, (Object)messageInfo.scope) && Objects.equals(this.senderId, messageInfo.senderId) && Objects.equals(this.tags, messageInfo.tags) && Objects.equals(this.title, messageInfo.title) && Objects.equals((Object)this.type, (Object)messageInfo.type) && Objects.equals(this.url, messageInfo.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appId, this.content, this.receiverIds, this.scope, this.senderId, this.tags, this.title, this.type, this.url});
    }

    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public static MessageInfo fromString(String json) throws IOException {
        return (MessageInfo)new ObjectMapper().readValue(json, MessageInfo.class);
    }

    public static enum TypeEnum {
        NUMBER_0(0),
        NUMBER_1(1),
        NUMBER_2(2);

        private Integer value;

        private TypeEnum(Integer value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ScopeEnum {
        GLOBAL("GLOBAL"),
        APP_GLOBAL("APP_GLOBAL"),
        SINGLE("SINGLE");

        private String value;

        private ScopeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScopeEnum fromValue(String text) {
            for (ScopeEnum b : ScopeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

