package org.yiwan.seiya.tower.bill.split.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.yiwan.seiya.tower.bill.split.model.BillInfo;
import org.yiwan.seiya.tower.bill.split.model.SplitRule;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * CreatePreInvoiceParam
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-08-15T11:29:37.147+08:00")
public class CreatePreInvoiceParam   {
    @JsonProperty("billInfo")
    private BillInfo billInfo = null;

    @JsonProperty("routingKey")
    private String routingKey = null;

    @JsonProperty("rule")
    private SplitRule rule = null;

    @JsonProperty("ruleCode")
    private String ruleCode = null;

    public CreatePreInvoiceParam withBillInfo(BillInfo billInfo) {
        this.billInfo = billInfo;
        return this;
    }

    /**
    * 单据信息
    * @return billInfo
    **/
    @ApiModelProperty(required = true, value = "单据信息")
  @NotNull

  @Valid

    public BillInfo getBillInfo() {
        return billInfo;
    }

    public void setBillInfo(BillInfo billInfo) {
        this.billInfo = billInfo;
    }

    public CreatePreInvoiceParam withRoutingKey(String routingKey) {
        this.routingKey = routingKey;
        return this;
    }

    /**
    * 路由key
    * @return routingKey
    **/
    @ApiModelProperty(required = true, value = "路由key")
  @NotNull


    public String getRoutingKey() {
        return routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public CreatePreInvoiceParam withRule(SplitRule rule) {
        this.rule = rule;
        return this;
    }

    /**
    * 规则信息
    * @return rule
    **/
    @ApiModelProperty(required = true, value = "规则信息")
  @NotNull

  @Valid

    public SplitRule getRule() {
        return rule;
    }

    public void setRule(SplitRule rule) {
        this.rule = rule;
    }

    public CreatePreInvoiceParam withRuleCode(String ruleCode) {
        this.ruleCode = ruleCode;
        return this;
    }

    /**
    * 规则code, 为空表示使用默认的
    * @return ruleCode
    **/
    @ApiModelProperty(value = "规则code, 为空表示使用默认的")


    public String getRuleCode() {
        return ruleCode;
    }

    public void setRuleCode(String ruleCode) {
        this.ruleCode = ruleCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreatePreInvoiceParam createPreInvoiceParam = (CreatePreInvoiceParam) o;
        return Objects.equals(this.billInfo, createPreInvoiceParam.billInfo) &&
            Objects.equals(this.routingKey, createPreInvoiceParam.routingKey) &&
            Objects.equals(this.rule, createPreInvoiceParam.rule) &&
            Objects.equals(this.ruleCode, createPreInvoiceParam.ruleCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billInfo, routingKey, rule, ruleCode);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link CreatePreInvoiceParam }.
     */
    public static CreatePreInvoiceParam fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, CreatePreInvoiceParam.class);
    }
}

