package org.yiwan.seiya.tower.bill.split.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.yiwan.seiya.tower.bill.split.model.PreInvoiceExt;
import org.yiwan.seiya.tower.bill.split.model.PreInvoiceItem;
import org.yiwan.seiya.tower.bill.split.model.PreInvoiceMain;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * SplitPreInvoiceInfo
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-08-15T11:29:37.147+08:00")
public class SplitPreInvoiceInfo   {
    @JsonProperty("preInvoiceExt")
    private PreInvoiceExt preInvoiceExt = null;

    @JsonProperty("preInvoiceItems")
    @Valid
    private List<PreInvoiceItem> preInvoiceItems = null;

    @JsonProperty("preInvoiceMain")
    private PreInvoiceMain preInvoiceMain = null;

    @JsonProperty("ruleId")
    private String ruleId = null;

    public SplitPreInvoiceInfo withPreInvoiceExt(PreInvoiceExt preInvoiceExt) {
        this.preInvoiceExt = preInvoiceExt;
        return this;
    }

    /**
    * 预制发票扩展信息
    * @return preInvoiceExt
    **/
    @ApiModelProperty(value = "预制发票扩展信息")

  @Valid

    public PreInvoiceExt getPreInvoiceExt() {
        return preInvoiceExt;
    }

    public void setPreInvoiceExt(PreInvoiceExt preInvoiceExt) {
        this.preInvoiceExt = preInvoiceExt;
    }

    public SplitPreInvoiceInfo withPreInvoiceItems(List<PreInvoiceItem> preInvoiceItems) {
        this.preInvoiceItems = preInvoiceItems;
        return this;
    }

    public SplitPreInvoiceInfo withPreInvoiceItemsAdd(PreInvoiceItem preInvoiceItems) {
        if (this.preInvoiceItems == null) {
            this.preInvoiceItems = new ArrayList<PreInvoiceItem>();
        }
        this.preInvoiceItems.add(preInvoiceItems);
        return this;
    }

    /**
    * 预制发票明细信息
    * @return preInvoiceItems
    **/
    @ApiModelProperty(value = "预制发票明细信息")

  @Valid

    public List<PreInvoiceItem> getPreInvoiceItems() {
        return preInvoiceItems;
    }

    public void setPreInvoiceItems(List<PreInvoiceItem> preInvoiceItems) {
        this.preInvoiceItems = preInvoiceItems;
    }

    public SplitPreInvoiceInfo withPreInvoiceMain(PreInvoiceMain preInvoiceMain) {
        this.preInvoiceMain = preInvoiceMain;
        return this;
    }

    /**
    * 预制发票主信息
    * @return preInvoiceMain
    **/
    @ApiModelProperty(value = "预制发票主信息")

  @Valid

    public PreInvoiceMain getPreInvoiceMain() {
        return preInvoiceMain;
    }

    public void setPreInvoiceMain(PreInvoiceMain preInvoiceMain) {
        this.preInvoiceMain = preInvoiceMain;
    }

    public SplitPreInvoiceInfo withRuleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    /**
    * 拆分规则id
    * @return ruleId
    **/
    @ApiModelProperty(value = "拆分规则id")


    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SplitPreInvoiceInfo splitPreInvoiceInfo = (SplitPreInvoiceInfo) o;
        return Objects.equals(this.preInvoiceExt, splitPreInvoiceInfo.preInvoiceExt) &&
            Objects.equals(this.preInvoiceItems, splitPreInvoiceInfo.preInvoiceItems) &&
            Objects.equals(this.preInvoiceMain, splitPreInvoiceInfo.preInvoiceMain) &&
            Objects.equals(this.ruleId, splitPreInvoiceInfo.ruleId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(preInvoiceExt, preInvoiceItems, preInvoiceMain, ruleId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link SplitPreInvoiceInfo }.
     */
    public static SplitPreInvoiceInfo fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, SplitPreInvoiceInfo.class);
    }
}

