package org.yiwan.seiya.tower.bill.split.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.yiwan.seiya.tower.bill.split.model.RemarkFieldMetadata;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * SplitRule
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-08-15T11:29:37.147+08:00")
public class SplitRule   {
    @JsonProperty("amountSplitRule")
    private String amountSplitRule = null;

    @JsonProperty("extRemark")
    private String extRemark = null;

    @JsonProperty("fixedRemarkText")
    private String fixedRemarkText = null;

    @JsonProperty("invoiceItemMaxRow")
    private Integer invoiceItemMaxRow = null;

    @JsonProperty("invoiceLimit")
    private BigDecimal invoiceLimit = null;

    @JsonProperty("invoiceSpec")
    private String invoiceSpec = null;

    @JsonProperty("invoiceType")
    private String invoiceType = null;

    @JsonProperty("itemSort")
    private String itemSort = null;

  /**
   * Gets or Sets priceMethod
   */
  public enum PriceMethodEnum {
    WITHOUT_TAX("WITHOUT_TAX"),
    
    WITH_TAX("WITH_TAX");

    private String value;

    PriceMethodEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PriceMethodEnum fromValue(String text) {
      for (PriceMethodEnum b : PriceMethodEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

    @JsonProperty("priceMethod")
    private PriceMethodEnum priceMethod = null;

    @JsonProperty("remarkFiledMetadataBeanList")
    @Valid
    private List<RemarkFieldMetadata> remarkFiledMetadataBeanList = null;

    @JsonProperty("ruleId")
    private Long ruleId = null;

    @JsonProperty("saleListOption")
    private String saleListOption = null;

    @JsonProperty("salesListMaxRow")
    private Integer salesListMaxRow = null;

    @JsonProperty("splitFiledList")
    @Valid
    private List<String> splitFiledList = null;

    @JsonProperty("unitPriceAmountOps")
    private String unitPriceAmountOps = null;

  /**
   * 零税率发票类型, 0 = 不处理，1=专改普
   */
  public enum ZeroTaxOptionEnum {
    NOT_PROCESS("NOT_PROCESS"),
    
    PROCESS("PROCESS");

    private String value;

    ZeroTaxOptionEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ZeroTaxOptionEnum fromValue(String text) {
      for (ZeroTaxOptionEnum b : ZeroTaxOptionEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

    @JsonProperty("zeroTaxOption")
    private ZeroTaxOptionEnum zeroTaxOption = null;

    public SplitRule withAmountSplitRule(String amountSplitRule) {
        this.amountSplitRule = amountSplitRule;
        return this;
    }

    /**
    * Get amountSplitRule
    * @return amountSplitRule
    **/
    @ApiModelProperty(required = true, value = "")
  @NotNull


    public String getAmountSplitRule() {
        return amountSplitRule;
    }

    public void setAmountSplitRule(String amountSplitRule) {
        this.amountSplitRule = amountSplitRule;
    }

    public SplitRule withExtRemark(String extRemark) {
        this.extRemark = extRemark;
        return this;
    }

    /**
    * 补充备注
    * @return extRemark
    **/
    @ApiModelProperty(value = "补充备注")


    public String getExtRemark() {
        return extRemark;
    }

    public void setExtRemark(String extRemark) {
        this.extRemark = extRemark;
    }

    public SplitRule withFixedRemarkText(String fixedRemarkText) {
        this.fixedRemarkText = fixedRemarkText;
        return this;
    }

    /**
    * 固定备注内容
    * @return fixedRemarkText
    **/
    @ApiModelProperty(value = "固定备注内容")


    public String getFixedRemarkText() {
        return fixedRemarkText;
    }

    public void setFixedRemarkText(String fixedRemarkText) {
        this.fixedRemarkText = fixedRemarkText;
    }

    public SplitRule withInvoiceItemMaxRow(Integer invoiceItemMaxRow) {
        this.invoiceItemMaxRow = invoiceItemMaxRow;
        return this;
    }

    /**
    * 发票票面明细最大数
    * @return invoiceItemMaxRow
    **/
    @ApiModelProperty(value = "发票票面明细最大数")


    public Integer getInvoiceItemMaxRow() {
        return invoiceItemMaxRow;
    }

    public void setInvoiceItemMaxRow(Integer invoiceItemMaxRow) {
        this.invoiceItemMaxRow = invoiceItemMaxRow;
    }

    public SplitRule withInvoiceLimit(BigDecimal invoiceLimit) {
        this.invoiceLimit = invoiceLimit;
        return this;
    }

    /**
    * Get invoiceLimit
    * @return invoiceLimit
    **/
    @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

    public BigDecimal getInvoiceLimit() {
        return invoiceLimit;
    }

    public void setInvoiceLimit(BigDecimal invoiceLimit) {
        this.invoiceLimit = invoiceLimit;
    }

    public SplitRule withInvoiceSpec(String invoiceSpec) {
        this.invoiceSpec = invoiceSpec;
        return this;
    }

    /**
    * 发票规格
    * @return invoiceSpec
    **/
    @ApiModelProperty(value = "发票规格")


    public String getInvoiceSpec() {
        return invoiceSpec;
    }

    public void setInvoiceSpec(String invoiceSpec) {
        this.invoiceSpec = invoiceSpec;
    }

    public SplitRule withInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
        return this;
    }

    /**
    * 发票类型
    * @return invoiceType
    **/
    @ApiModelProperty(value = "发票类型")


    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public SplitRule withItemSort(String itemSort) {
        this.itemSort = itemSort;
        return this;
    }

    /**
    * Get itemSort
    * @return itemSort
    **/
    @ApiModelProperty(required = true, value = "")
  @NotNull


    public String getItemSort() {
        return itemSort;
    }

    public void setItemSort(String itemSort) {
        this.itemSort = itemSort;
    }

    public SplitRule withPriceMethod(PriceMethodEnum priceMethod) {
        this.priceMethod = priceMethod;
        return this;
    }

    /**
    * Get priceMethod
    * @return priceMethod
    **/
    @ApiModelProperty(value = "")


    public PriceMethodEnum getPriceMethod() {
        return priceMethod;
    }

    public void setPriceMethod(PriceMethodEnum priceMethod) {
        this.priceMethod = priceMethod;
    }

    public SplitRule withRemarkFiledMetadataBeanList(List<RemarkFieldMetadata> remarkFiledMetadataBeanList) {
        this.remarkFiledMetadataBeanList = remarkFiledMetadataBeanList;
        return this;
    }

    public SplitRule withRemarkFiledMetadataBeanListAdd(RemarkFieldMetadata remarkFiledMetadataBeanList) {
        if (this.remarkFiledMetadataBeanList == null) {
            this.remarkFiledMetadataBeanList = new ArrayList<RemarkFieldMetadata>();
        }
        this.remarkFiledMetadataBeanList.add(remarkFiledMetadataBeanList);
        return this;
    }

    /**
    * 备注列表元数据
    * @return remarkFiledMetadataBeanList
    **/
    @ApiModelProperty(value = "备注列表元数据")

  @Valid

    public List<RemarkFieldMetadata> getRemarkFiledMetadataBeanList() {
        return remarkFiledMetadataBeanList;
    }

    public void setRemarkFiledMetadataBeanList(List<RemarkFieldMetadata> remarkFiledMetadataBeanList) {
        this.remarkFiledMetadataBeanList = remarkFiledMetadataBeanList;
    }

    public SplitRule withRuleId(Long ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    /**
    * Get ruleId
    * @return ruleId
    **/
    @ApiModelProperty(required = true, value = "")
  @NotNull


    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public SplitRule withSaleListOption(String saleListOption) {
        this.saleListOption = saleListOption;
        return this;
    }

    /**
    * Get saleListOption
    * @return saleListOption
    **/
    @ApiModelProperty(required = true, value = "")
  @NotNull


    public String getSaleListOption() {
        return saleListOption;
    }

    public void setSaleListOption(String saleListOption) {
        this.saleListOption = saleListOption;
    }

    public SplitRule withSalesListMaxRow(Integer salesListMaxRow) {
        this.salesListMaxRow = salesListMaxRow;
        return this;
    }

    /**
    * 销货清单最大行数
    * @return salesListMaxRow
    **/
    @ApiModelProperty(value = "销货清单最大行数")


    public Integer getSalesListMaxRow() {
        return salesListMaxRow;
    }

    public void setSalesListMaxRow(Integer salesListMaxRow) {
        this.salesListMaxRow = salesListMaxRow;
    }

    public SplitRule withSplitFiledList(List<String> splitFiledList) {
        this.splitFiledList = splitFiledList;
        return this;
    }

    public SplitRule withSplitFiledListAdd(String splitFiledList) {
        if (this.splitFiledList == null) {
            this.splitFiledList = new ArrayList<String>();
        }
        this.splitFiledList.add(splitFiledList);
        return this;
    }

    /**
    * 自定义拆票字段
    * @return splitFiledList
    **/
    @ApiModelProperty(value = "自定义拆票字段")


    public List<String> getSplitFiledList() {
        return splitFiledList;
    }

    public void setSplitFiledList(List<String> splitFiledList) {
        this.splitFiledList = splitFiledList;
    }

    public SplitRule withUnitPriceAmountOps(String unitPriceAmountOps) {
        this.unitPriceAmountOps = unitPriceAmountOps;
        return this;
    }

    /**
    * 单价数量选项 0-打印单价数量 1-不打印单价数量
    * @return unitPriceAmountOps
    **/
    @ApiModelProperty(value = "单价数量选项 0-打印单价数量 1-不打印单价数量")


    public String getUnitPriceAmountOps() {
        return unitPriceAmountOps;
    }

    public void setUnitPriceAmountOps(String unitPriceAmountOps) {
        this.unitPriceAmountOps = unitPriceAmountOps;
    }

    public SplitRule withZeroTaxOption(ZeroTaxOptionEnum zeroTaxOption) {
        this.zeroTaxOption = zeroTaxOption;
        return this;
    }

    /**
    * 零税率发票类型, 0 = 不处理，1=专改普
    * @return zeroTaxOption
    **/
    @ApiModelProperty(required = true, value = "零税率发票类型, 0 = 不处理，1=专改普")
  @NotNull


    public ZeroTaxOptionEnum getZeroTaxOption() {
        return zeroTaxOption;
    }

    public void setZeroTaxOption(ZeroTaxOptionEnum zeroTaxOption) {
        this.zeroTaxOption = zeroTaxOption;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SplitRule splitRule = (SplitRule) o;
        return Objects.equals(this.amountSplitRule, splitRule.amountSplitRule) &&
            Objects.equals(this.extRemark, splitRule.extRemark) &&
            Objects.equals(this.fixedRemarkText, splitRule.fixedRemarkText) &&
            Objects.equals(this.invoiceItemMaxRow, splitRule.invoiceItemMaxRow) &&
            Objects.equals(this.invoiceLimit, splitRule.invoiceLimit) &&
            Objects.equals(this.invoiceSpec, splitRule.invoiceSpec) &&
            Objects.equals(this.invoiceType, splitRule.invoiceType) &&
            Objects.equals(this.itemSort, splitRule.itemSort) &&
            Objects.equals(this.priceMethod, splitRule.priceMethod) &&
            Objects.equals(this.remarkFiledMetadataBeanList, splitRule.remarkFiledMetadataBeanList) &&
            Objects.equals(this.ruleId, splitRule.ruleId) &&
            Objects.equals(this.saleListOption, splitRule.saleListOption) &&
            Objects.equals(this.salesListMaxRow, splitRule.salesListMaxRow) &&
            Objects.equals(this.splitFiledList, splitRule.splitFiledList) &&
            Objects.equals(this.unitPriceAmountOps, splitRule.unitPriceAmountOps) &&
            Objects.equals(this.zeroTaxOption, splitRule.zeroTaxOption);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amountSplitRule, extRemark, fixedRemarkText, invoiceItemMaxRow, invoiceLimit, invoiceSpec, invoiceType, itemSort, priceMethod, remarkFiledMetadataBeanList, ruleId, saleListOption, salesListMaxRow, splitFiledList, unitPriceAmountOps, zeroTaxOption);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link SplitRule }.
     */
    public static SplitRule fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, SplitRule.class);
    }
}

