package org.yiwan.seiya.mybatis.dbsetup.plugin;

/*
 * The MIT License
 *
 * Copyright (c) 2006, The Codehaus
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.dbunit.ant.Export;
import org.dbunit.ant.Query;
import org.dbunit.ant.Table;
import org.dbunit.database.IDatabaseConnection;

import java.io.File;

/**
 * Execute Mybatis database export operation
 *
 * @author <a href="mailto:tcwmj@hotmail.com">Kenny Wong</a>
 */
@Mojo(name = "export")
public class MybatisDBExportMojo extends AbstractMybatisDBSetupMojo {
    /**
     * Location of exported DataSet file
     */
    protected File outputDir;

    /**
     * List of database Table
     */
    protected String[] tables;

    /**
     * Set to true to order exported data according to integrity constraints defined in DB.
     */
    protected boolean ordered;

    /**
     * Encoding of exported data.
     */
    protected String encoding;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();

    }
}
