/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.mybatis.dbsetup.plugin;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.yiwan.seiya.mybatis.extension.entity.BaseEntity;
import org.yiwan.seiya.mybatis.extension.mapper.BaseMapper;

public abstract class AbstractMybatisDBSetupMojo
extends AbstractMojo {
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(required=true)
    private String[] contexts;
    @Parameter(defaultValue="false")
    private boolean classpathedContexts;
    @Parameter(defaultValue="org.yiwan.seiya.mybatis.extension.entity.BaseEntity")
    String baseEntityType;
    @Parameter(defaultValue="org.yiwan.seiya.mybatis.extension.mapper.BaseMapper")
    String baseMapperType;
    ApplicationContext applicationContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping to process mybatis dbsetup...");
            return;
        }
        this.loadApplicationContexts();
    }

    private void loadApplicationContexts() {
        this.applicationContext = this.classpathedContexts ? new ClassPathXmlApplicationContext(this.contexts) : new FileSystemXmlApplicationContext(this.contexts);
    }

    Class<? extends BaseEntity> getBaseEntityType() throws ClassNotFoundException {
        return Class.forName(this.baseEntityType);
    }

    Class<? extends BaseMapper> getBaseMapperType() throws ClassNotFoundException {
        return Class.forName(this.baseMapperType);
    }
}

