/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.mybatis.dbsetup.plugin;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.yiwan.seiya.core.util.DateTimeUtils;
import org.yiwan.seiya.mybatis.dbsetup.plugin.AbstractMybatisDBSetupMojo;
import org.yiwan.seiya.mybatis.extension.mapper.BaseMapper;

@Mojo(name="export")
public class MybatisDBExportMojo
extends AbstractMybatisDBSetupMojo {
    static final String APPLICATION_CONTEXT_TEMPLATE = "application-context-template.vm";
    @Parameter(defaultValue="${project.build.directory}/dbsetup-export.xml", required=true)
    protected File outputFile;
    @Parameter
    protected String[] tables;
    @Parameter
    protected boolean ordered;
    @Parameter(defaultValue="UTF-8")
    protected String encoding;
    private Template velocityTemplate;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        Class<? extends BaseMapper> clazz;
        super.execute();
        try {
            clazz = this.getBaseMapperType();
        }
        catch (ClassNotFoundException e) {
            this.getLog().error((CharSequence)String.format("class %s was not found", this.baseMapperType), (Throwable)e);
            return;
        }
        Map mapperBeans = this.applicationContext.getBeansOfType(clazz);
        ArrayList entities = new ArrayList();
        mapperBeans.forEach((k, v) -> entities.addAll(v.selectAll()));
        List<Map> entityList = this.rebuildEntities(entities);
        this.initTemplate();
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), this.encoding));){
            this.writeContent(bufferedWriter, entityList);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error on creating file " + this.outputFile, (Exception)e);
        }
    }

    private List<Map> rebuildEntities(List entities) {
        return entities.stream().map(entity -> {
            Map<String, Object> map = null;
            try {
                map = this.toMap(entity);
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
            }
            return map;
        }).collect(Collectors.toList());
    }

    private Map<String, Object> toMap(Object object) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        PropertyDescriptor[] propertyDescriptors;
        HashMap<String, Object> map = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            String key = property.getName();
            if (0 == key.compareToIgnoreCase("class")) {
                map.put(key, object.getClass().getName());
                continue;
            }
            Method readMethod = property.getReadMethod();
            Object value = readMethod != null ? readMethod.invoke(object, new Object[0]) : null;
            map.put(key, value);
        }
        return map;
    }

    private void initTemplate() {
        Properties props = new Properties();
        props.put("resource.loader", "class");
        props.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        VelocityEngine engine = new VelocityEngine(props);
        engine.init();
        this.velocityTemplate = engine.getTemplate(APPLICATION_CONTEXT_TEMPLATE, this.encoding);
    }

    private void writeContent(Writer writer, List<Map> entityList) {
        VelocityContext context = new VelocityContext();
        context.put("entityList", entityList);
        context.put("dateformat", (Object)new DateTimeUtils());
        this.velocityTemplate.merge((Context)context, writer);
    }
}

