/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.mybatis.dbsetup.plugin;

import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.yiwan.seiya.mybatis.dbsetup.plugin.AbstractMybatisDBSetupMojo;
import org.yiwan.seiya.mybatis.extension.entity.BaseEntity;

@Mojo(name="import")
public class MybatisDBImportMojo
extends AbstractMybatisDBSetupMojo {
    @Parameter(defaultValue="REPLACE")
    private String type;
    @Parameter(required=true)
    private String[] datasets;
    @Parameter(defaultValue="false")
    private boolean classpathedDatasets;
    private ApplicationContext datasetContext;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        Class<? extends BaseEntity> clazz;
        super.execute();
        this.loadDatasetContexts();
        try {
            clazz = this.getBaseEntityType();
        }
        catch (ClassNotFoundException e) {
            this.getLog().error((CharSequence)String.format("class %s was not found", this.baseEntityType), (Throwable)e);
            return;
        }
        Map dataSetBeans = this.datasetContext.getBeansOfType(clazz);
        Set entrySet = dataSetBeans.entrySet();
        AutowireCapableBeanFactory autowireCapableBeanFactory = this.applicationContext.getAutowireCapableBeanFactory();
        this.getLog().info((CharSequence)"process starting");
        switch (this.type.toUpperCase()) {
            case "INSERT": {
                this.processInserting(entrySet, autowireCapableBeanFactory);
                break;
            }
            case "UPDATE": {
                this.processUpdating(entrySet, autowireCapableBeanFactory);
                break;
            }
            case "DELETE": {
                this.processDeleting(entrySet, autowireCapableBeanFactory);
                break;
            }
            case "REPLACE": {
                this.processReplacing(entrySet, autowireCapableBeanFactory);
                break;
            }
            default: {
                this.getLog().info((CharSequence)"process nothing");
            }
        }
        this.getLog().info((CharSequence)"process done");
    }

    private void processInserting(Set<? extends Map.Entry<String, ? extends BaseEntity>> entrySet, AutowireCapableBeanFactory autowireCapableBeanFactory) {
        for (Map.Entry<String, ? extends BaseEntity> entry : entrySet) {
            this.getLog().debug((CharSequence)String.format("inserting %s", entry.getKey()));
            BaseEntity entryValue = entry.getValue();
            autowireCapableBeanFactory.autowireBean((Object)entryValue);
            entryValue.insertSelective();
        }
    }

    private void processUpdating(Set<? extends Map.Entry<String, ? extends BaseEntity>> entrySet, AutowireCapableBeanFactory autowireCapableBeanFactory) {
        for (Map.Entry<String, ? extends BaseEntity> entry : entrySet) {
            this.getLog().debug((CharSequence)String.format("updating %s", entry.getKey()));
            BaseEntity entryValue = entry.getValue();
            autowireCapableBeanFactory.autowireBean((Object)entryValue);
            entryValue.updateByPrimaryKeySelective();
        }
    }

    private void processDeleting(Set<? extends Map.Entry<String, ? extends BaseEntity>> entrySet, AutowireCapableBeanFactory autowireCapableBeanFactory) {
        for (Map.Entry<String, ? extends BaseEntity> entry : entrySet) {
            this.getLog().debug((CharSequence)String.format("deleting %s", entry.getKey()));
            BaseEntity entryValue = entry.getValue();
            autowireCapableBeanFactory.autowireBean((Object)entryValue);
            entryValue.delete();
        }
    }

    private void processReplacing(Set<? extends Map.Entry<String, ? extends BaseEntity>> entrySet, AutowireCapableBeanFactory autowireCapableBeanFactory) {
        for (Map.Entry<String, ? extends BaseEntity> entry : entrySet) {
            this.getLog().debug((CharSequence)String.format("replacing %s", entry.getKey()));
            BaseEntity entryValue = entry.getValue();
            autowireCapableBeanFactory.autowireBean((Object)entryValue);
            entryValue.replace();
        }
    }

    private void loadDatasetContexts() {
        this.datasetContext = this.classpathedDatasets ? new ClassPathXmlApplicationContext(this.datasets) : new FileSystemXmlApplicationContext(this.datasets);
    }
}

