/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.config;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.maven.plugins.annotations.Parameter;
import org.yiwan.seiya.config.rules.DbType;

public class DataSourceConfig {
    @Parameter
    private DbType dbType;
    @Parameter(required=true)
    private String url;
    @Parameter(required=true)
    private String driverName;
    @Parameter(required=true)
    private String username;
    @Parameter(required=true)
    private String password;

    public DbType getDbType() {
        if (null == this.dbType) {
            if (this.driverName.contains("mysql")) {
                this.dbType = DbType.MYSQL;
            } else if (this.driverName.contains("oracle")) {
                this.dbType = DbType.ORACLE;
            }
        }
        return this.dbType;
    }

    public Connection getConn() {
        Connection conn = null;
        try {
            Class.forName(this.driverName);
            conn = DriverManager.getConnection(this.url, this.username, this.password);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return conn;
    }
}

