/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.config.builder;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.yiwan.seiya.config.DataSourceConfig;
import org.yiwan.seiya.config.PackageConfig;
import org.yiwan.seiya.config.StrategyConfig;
import org.yiwan.seiya.config.TemplateConfig;
import org.yiwan.seiya.config.po.TableField;
import org.yiwan.seiya.config.po.TableInfo;
import org.yiwan.seiya.config.rules.DbType;
import org.yiwan.seiya.config.rules.IdStrategy;
import org.yiwan.seiya.config.rules.NamingStrategy;
import org.yiwan.seiya.config.rules.QuerySQL;

public class ConfigBuilder {
    private Connection connection;
    private QuerySQL querySQL;
    private String superEntityClass;
    private String superMapperClass;
    private String superServiceClass;
    private String superServiceImplClass;
    private String superControllerClass;
    private String idType;
    private List<TableInfo> tableInfoList;
    private Map<String, String> packageInfo;
    private Map<String, String> pathInfo;
    private TemplateConfig template;

    public ConfigBuilder(PackageConfig packageConfig, DataSourceConfig dataSourceConfig, StrategyConfig strategyConfig, TemplateConfig template, String outputDir) {
        this.handlerPackage(outputDir, packageConfig);
        this.handlerDataSource(dataSourceConfig);
        this.handlerStrategy(strategyConfig);
        this.template = template;
    }

    public Map<String, String> getPackageInfo() {
        return this.packageInfo;
    }

    public Map<String, String> getPathInfo() {
        return this.pathInfo;
    }

    public String getSuperEntityClass() {
        return this.superEntityClass;
    }

    public String getSuperMapperClass() {
        return this.superMapperClass;
    }

    public String getSuperServiceClass() {
        return this.superServiceClass;
    }

    public String getSuperServiceImplClass() {
        return this.superServiceImplClass;
    }

    public String getSuperControllerClass() {
        return this.superControllerClass;
    }

    public String getIdType() {
        return this.idType;
    }

    public List<TableInfo> getTableInfoList() {
        return this.tableInfoList;
    }

    public TemplateConfig getTemplate() {
        return this.template == null ? new TemplateConfig() : this.template;
    }

    private void handlerPackage(String outputDir, PackageConfig config) {
        this.packageInfo = new HashMap<String, String>();
        this.packageInfo.put("ModuleName", config.getModuleName());
        this.packageInfo.put("Entity", this.joinPackage(config.getParent(), config.getEntity()));
        this.packageInfo.put("Mapper", this.joinPackage(config.getParent(), config.getMapper()));
        this.packageInfo.put("Xml", this.joinPackage(config.getParent(), config.getXml()));
        this.packageInfo.put("Service", this.joinPackage(config.getParent(), config.getService()));
        this.packageInfo.put("ServiceImpl", this.joinPackage(config.getParent(), config.getServiceImpl()));
        this.packageInfo.put("Controller", this.joinPackage(config.getParent(), config.getController()));
        this.pathInfo = new HashMap<String, String>();
        this.pathInfo.put("entity_path", this.joinPath(outputDir, this.packageInfo.get("Entity")));
        this.pathInfo.put("mapper_path", this.joinPath(outputDir, this.packageInfo.get("Mapper")));
        this.pathInfo.put("xml_path", this.joinPath(outputDir, this.packageInfo.get("Xml")));
        this.pathInfo.put("serivce_path", this.joinPath(outputDir, this.packageInfo.get("Service")));
        this.pathInfo.put("serviceimpl_path", this.joinPath(outputDir, this.packageInfo.get("ServiceImpl")));
        this.pathInfo.put("controller_path", this.joinPath(outputDir, this.packageInfo.get("Controller")));
    }

    private void handlerDataSource(DataSourceConfig config) {
        this.connection = config.getConn();
        this.querySQL = this.getQuerySQL(config.getDbType());
    }

    private void handlerStrategy(StrategyConfig config) {
        this.processTypes(config);
        this.tableInfoList = this.getTablesInfo(config);
    }

    private void processTypes(StrategyConfig config) {
        this.superServiceClass = StringUtils.isBlank((String)config.getSuperServiceClass()) ? "com.baomidou.mybatisplus.extension.service.IService" : config.getSuperServiceClass();
        this.superServiceImplClass = StringUtils.isBlank((String)config.getSuperServiceImplClass()) ? "com.baomidou.mybatisplus.extension.service.impl.ServiceImpl" : config.getSuperServiceImplClass();
        this.superMapperClass = StringUtils.isBlank((String)config.getSuperMapperClass()) ? "com.baomidou.mybatisplus.core.mapper.BaseMapper" : config.getSuperMapperClass();
        this.superEntityClass = config.getSuperEntityClass();
        this.superControllerClass = config.getSuperControllerClass();
        this.idType = config.getIdGenType() == IdStrategy.auto ? IdStrategy.auto.getValue() : (config.getIdGenType() == IdStrategy.input ? IdStrategy.input.getValue() : (config.getIdGenType() == IdStrategy.uuid ? IdStrategy.uuid.getValue() : IdStrategy.id_worker.getValue()));
    }

    private List<TableInfo> processTable(List<TableInfo> tableList, NamingStrategy strategy, String tablePrefix) {
        for (TableInfo tableInfo : tableList) {
            tableInfo.setEntityName(NamingStrategy.capitalFirst(this.processName(tableInfo.getName(), strategy, tablePrefix)));
            tableInfo.setMapperName(tableInfo.getEntityName() + "Mapper");
            tableInfo.setXmlName(tableInfo.getMapperName());
            tableInfo.setServiceName("I" + tableInfo.getEntityName() + "Service");
            tableInfo.setServiceImplName(tableInfo.getEntityName() + "ServiceImpl");
            tableInfo.setControllerName(tableInfo.getEntityName() + "Controller");
        }
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TableInfo> getTablesInfo(StrategyConfig config) {
        boolean isExclude;
        boolean isInclude = null != config.getInclude() && config.getInclude().length > 0;
        boolean bl = isExclude = null != config.getExclude() && config.getExclude().length > 0;
        if (isInclude && isExclude) {
            throw new RuntimeException("<strategy> \u6807\u7b7e\u4e2d <include> \u4e0e <exclude> \u53ea\u80fd\u914d\u7f6e\u4e00\u9879\uff01");
        }
        ArrayList<TableInfo> tableList = new ArrayList<TableInfo>();
        HashSet<String> notExistTables = new HashSet<String>();
        NamingStrategy strategy = config.getNaming();
        NamingStrategy fieldStrategy = config.getFieldNaming();
        PreparedStatement pstate = null;
        try {
            pstate = this.connection.prepareStatement(this.querySQL.getTableCommentsSql());
            ResultSet results = pstate.executeQuery();
            while (results.next()) {
                String tableName = results.getString(this.querySQL.getTableName());
                if (StringUtils.isNotBlank((String)tableName)) {
                    String tableComment = results.getString(this.querySQL.getTableComment());
                    TableInfo tableInfo = new TableInfo();
                    if (isInclude) {
                        for (String includeTab : config.getInclude()) {
                            if (includeTab.equalsIgnoreCase(tableName)) {
                                tableInfo.setName(tableName);
                                tableInfo.setComment(tableComment);
                                continue;
                            }
                            notExistTables.add(includeTab);
                        }
                    } else if (isExclude) {
                        for (String excludeTab : config.getExclude()) {
                            if (!excludeTab.equalsIgnoreCase(tableName)) {
                                tableInfo.setName(tableName);
                                tableInfo.setComment(tableComment);
                                continue;
                            }
                            notExistTables.add(excludeTab);
                        }
                    } else {
                        tableInfo.setName(tableName);
                        tableInfo.setComment(tableComment);
                    }
                    if (!StringUtils.isNotBlank((String)tableInfo.getName())) continue;
                    List<TableField> fieldList = this.getListFields(tableInfo.getName(), fieldStrategy);
                    tableInfo.setFields(fieldList);
                    tableList.add(tableInfo);
                    continue;
                }
                System.err.println("\u5f53\u524d\u6570\u636e\u5e93\u4e3a\u7a7a\uff01\uff01\uff01");
            }
            for (TableInfo tabInfo : tableList) {
                notExistTables.remove(tabInfo.getName());
            }
            if (notExistTables.size() > 0) {
                System.err.println("\u8868 " + notExistTables + " \u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (pstate != null) {
                    pstate.close();
                }
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return this.processTable(tableList, strategy, config.getTablePrefix());
    }

    private List<TableField> getListFields(String tableName, NamingStrategy strategy) throws SQLException {
        boolean havedId = false;
        PreparedStatement pstate = this.connection.prepareStatement(String.format(this.querySQL.getTableFieldsSql(), tableName));
        ResultSet results = pstate.executeQuery();
        ArrayList<TableField> fieldList = new ArrayList<TableField>();
        while (results.next()) {
            boolean isId;
            TableField field = new TableField();
            String key = results.getString(this.querySQL.getFieldKey());
            boolean bl = isId = StringUtils.isNotBlank((String)key) && key.toUpperCase().equals("PRI");
            if (isId && !havedId) {
                field.setKeyFlag(true);
                havedId = true;
            } else {
                field.setKeyFlag(false);
            }
            field.setName(results.getString(this.querySQL.getFieldName()));
            field.setType(results.getString(this.querySQL.getFieldType()));
            field.setPropertyName(this.processName(field.getName(), strategy));
            field.setPropertyType(this.processFiledType(field.getType()));
            field.setComment(results.getString(this.querySQL.getFieldComment()));
            fieldList.add(field);
        }
        return fieldList;
    }

    private String joinPath(String parentDir, String packageName) {
        if (StringUtils.isEmpty((String)parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith((String)parentDir, (String)File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    private String joinPackage(String parent, String subPackage) {
        if (StringUtils.isBlank((String)parent)) {
            return subPackage;
        }
        return parent + "." + subPackage;
    }

    private String processFiledType(String type) {
        if (QuerySQL.MYSQL == this.querySQL) {
            return this.processMySqlType(type);
        }
        if (QuerySQL.ORACLE == this.querySQL) {
            return this.processOracleType(type);
        }
        return null;
    }

    private String processName(String name, NamingStrategy strategy) {
        return this.processName(name, strategy, null);
    }

    private String processName(String name, NamingStrategy strategy, String tablePrefix) {
        String propertyName = "";
        propertyName = strategy == NamingStrategy.remove_prefix_and_camel ? NamingStrategy.removePrefixAndCamel(name, tablePrefix) : (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.underlineToCamel(name) : (strategy == NamingStrategy.remove_prefix ? NamingStrategy.removePrefix(name, tablePrefix) : name));
        return propertyName;
    }

    private String processMySqlType(String type) {
        String t = type.toLowerCase();
        if (t.contains("char") || t.contains("text")) {
            return "String";
        }
        if (t.contains("bigint")) {
            return "Long";
        }
        if (t.contains("int")) {
            return "Integer";
        }
        if (t.contains("date") || t.contains("time") || t.contains("year")) {
            return "Date";
        }
        if (t.contains("text")) {
            return "String";
        }
        if (t.contains("bit")) {
            return "Boolean";
        }
        if (t.contains("decimal")) {
            return "BigDecimal";
        }
        if (t.contains("blob")) {
            return "byte[]";
        }
        if (t.contains("float")) {
            return "Float";
        }
        if (t.contains("double")) {
            return "Double";
        }
        if (t.contains("json") || t.contains("enum")) {
            return "String";
        }
        return "String";
    }

    private String processOracleType(String type) {
        String t = type.toUpperCase();
        if (t.contains("CHAR")) {
            return "String";
        }
        if (t.contains("DATE") || t.contains("TIMESTAMP")) {
            return "Date";
        }
        if (t.contains("NUMBER")) {
            if (t.matches("NUMBER\\(+\\d{1}+\\)")) {
                return "Integer";
            }
            if (t.matches("NUMBER\\(+\\d{2}+\\)")) {
                return "Long";
            }
            return "Double";
        }
        if (t.contains("FLOAT")) {
            return "Float";
        }
        if (t.contains("BLOB")) {
            return "Object";
        }
        if (t.contains("RAW")) {
            return "byte[]";
        }
        return "String";
    }

    private QuerySQL getQuerySQL(DbType dbType) {
        for (QuerySQL qs : QuerySQL.values()) {
            if (!qs.getDbType().equals(dbType.getValue())) continue;
            return qs;
        }
        return QuerySQL.MYSQL;
    }
}

