/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.phoenix.test.junit4;

import com.github.springtestdbunit.annotation.DbUnitConfiguration;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.util.Map;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.ContextConfiguration;
import org.yiwan.seiya.core.util.ResourceLoader;
import org.yiwan.seiya.phoenix.core.constant.PhoenixServices;
import org.yiwan.seiya.phoenix.test.junit4.PhoenixDBUnitJUnit4SpringTests;
import org.yiwan.seiya.springtestdbunit.operation.MysqlDatabaseOperationLookup;

@ContextConfiguration(locations={"classpath:phoenix-dbunit-ds.xml"})
@DbUnitConfiguration(databaseConnection={"phoenix-ucenter", "phoenix-ucenter-log", "phoenix-bss", "phoenix-bss-log"}, databaseOperationLookup=MysqlDatabaseOperationLookup.class)
public class PhoenixBssOperationAppDBUnitJUnit4SpringTests
extends PhoenixDBUnitJUnit4SpringTests {
    private static final Logger log = LoggerFactory.getLogger(PhoenixBssOperationAppDBUnitJUnit4SpringTests.class);
    protected static final String LOGIN_REQUEST_URL = "/api/v1/bss/security/login";
    protected static final String LOGIN_REQUEST_TEMPLATE = "login.json";
    protected final Map phoenixConfig = (Map)config.get(PhoenixServices.PHOENIX_BSS_OPERATION_APP.getValue());
    protected final String username = ((Map)this.phoenixConfig.get("login")).get("username").toString();
    protected final String password = ((Map)this.phoenixConfig.get("login")).get("password").toString();
    private Boolean loginRequired = true;

    @Override
    @Before
    public void before() throws IOException {
        super.before();
        if (this.loginRequired.booleanValue()) {
            String token = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().spec(this.requestSpec).body(String.format(ResourceLoader.loadFile((String)LOGIN_REQUEST_TEMPLATE), this.username, this.password)).when().post(LOGIN_REQUEST_URL, new Object[0])).then()).spec(this.responseSpec)).statusCode(200)).body("code", Matchers.equalTo((Object)1), new Object[0])).extract().path("token", new String[0]);
            this.requestSpecBuilder.addHeader("X-Access-Token", token);
            this.requestSpec = this.requestSpecBuilder.build();
        }
    }

    public void setLoginRequired(Boolean loginRequired) {
        this.loginRequired = loginRequired;
    }
}

