/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.phoenix.test.junit4;

import com.github.springtestdbunit.DbUnitTestExecutionListener;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.parsing.Parser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.support.DirtiesContextTestExecutionListener;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.yiwan.seiya.core.util.ResourceLoader;
import org.yiwan.seiya.phoenix.test.junit4.PhoenixJUnit4SpringTests;

@ContextConfiguration(locations={"classpath:phoenix-dbunit-ds.xml"})
@TestExecutionListeners(value={DependencyInjectionTestExecutionListener.class, DirtiesContextTestExecutionListener.class, TransactionalTestExecutionListener.class, DbUnitTestExecutionListener.class})
public class PhoenixDBUnitJUnit4SpringTests
extends PhoenixJUnit4SpringTests {
    private static final Logger log = LoggerFactory.getLogger(PhoenixDBUnitJUnit4SpringTests.class);
    protected static final String PHOENIX_BSS_INIT = "classpath:phoenix-bss-init.xml";
    protected static final String PHOENIX_UCENTER_INIT = "classpath:phoenix-ucenter-init.xml";
    protected static final String PHOENIX_NOTICE_INIT = "classpath:phoenix-notice-init.xml";
    protected static final Map config = ResourceLoader.loadYaml((String)"config.yml");
    protected static final String DEFAULT_REQUEST = "request.json";
    protected static final String DEFAULT_RESPONSE = "response.json";
    protected static final String DEFAULT_SETUP = "setup.xml";
    protected static final String DEFAULT_EXPECT = "expect.xml";
    protected static final String DEFAULT_TEARDOWN = "teardown.xml";
    @Rule
    public TestName testName = new TestName();
    protected StringBuffer dataPath;

    @BeforeClass
    public static void beforeClass() {
        RestAssured.defaultParser = Parser.JSON;
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    @AfterClass
    public static void afterClass() {
        RestAssured.reset();
    }

    @Before
    public void before() throws IOException {
        String[] packageSplits = ((Object)((Object)this)).getClass().getPackage().getName().split("\\.");
        this.dataPath = new StringBuffer(packageSplits[packageSplits.length - 1]);
        this.dataPath.append(File.separator);
        this.dataPath.append(((Object)((Object)this)).getClass().getSimpleName());
        this.dataPath.append(File.separator);
        this.dataPath.append(this.testName.getMethodName());
        this.dataPath.append(File.separator);
        this.responseSpec = this.responseSpecBuilder.build();
        this.requestSpecBuilder.setAccept(ContentType.JSON.withCharset(Charset.forName("UTF-8")));
        this.requestSpecBuilder.setContentType(ContentType.JSON.withCharset(Charset.forName("UTF-8")));
        this.requestSpec = this.requestSpecBuilder.build();
    }

    @After
    public void after() {
    }

    protected String loadData(String fileName) throws IOException {
        String filePath = this.dataPath.toString() + fileName;
        log.info(String.format("loading content from %s", filePath));
        return ResourceLoader.loadFile((String)filePath);
    }

    protected String loadRequest() throws IOException {
        return this.loadData(DEFAULT_REQUEST);
    }

    protected String loadResponse() throws IOException {
        return this.loadData(DEFAULT_RESPONSE);
    }
}

