/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.phoenix.test.junit4;

import com.github.springtestdbunit.annotation.DbUnitConfiguration;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.util.Map;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.test.context.ContextConfiguration;
import org.yiwan.seiya.core.util.ResourceLoader;
import org.yiwan.seiya.phoenix.core.constant.PhoenixServices;
import org.yiwan.seiya.phoenix.test.junit4.PhoenixDBUnitJUnit4SpringTests;
import org.yiwan.seiya.springtestdbunit.operation.MysqlDatabaseOperationLookup;

@ContextConfiguration(locations={"classpath:phoenix-dbunit-ds.xml"})
@DbUnitConfiguration(databaseConnection={"phoenix-ucenter", "phoenix-ucenter-log", "phoenix-bss", "phoenix-bss-log"}, databaseOperationLookup=MysqlDatabaseOperationLookup.class)
public class PhoenixUcenterAppDBUnitJUnit4SpringTests
extends PhoenixDBUnitJUnit4SpringTests {
    private static final Logger log = LoggerFactory.getLogger(PhoenixUcenterAppDBUnitJUnit4SpringTests.class);
    private LoginMode loginMode = LoginMode.SUPER;
    @Value(value="${services.phoenix-ucenter-app.restAssured.baseURI}")
    protected String baseURI;
    @Value(value="${services.phoenix-ucenter-app.restAssured.port}")
    protected Integer port;
    @Value(value="${services.phoenix-ucenter-app.restAssured.basePath}")
    protected String basePath;
    protected static final String SUPER_LOGIN_REQUEST_URL = "/api/v1/ucenter/security/superLogin";
    protected static final String NORMAL_LOGIN_REQUEST_URL = "/api/v1/ucenter/security/normalLogin";
    protected static final String LOGIN_REQUEST_TEMPLATE = "login.json";
    protected final Map phoenixConfig = (Map)config.get(PhoenixServices.PHOENIX_UCENTER_APP.getValue());
    protected final Map userConf = (Map)this.phoenixConfig.get("user");
    protected String username = ((Map)this.userConf.get("login")).get("username").toString();
    protected String password = ((Map)this.userConf.get("login")).get("password").toString();
    protected final Map adminConf = (Map)this.phoenixConfig.get("admin");
    protected String adminUsername = ((Map)this.adminConf.get("login")).get("username").toString();
    protected String adminPassword = ((Map)this.adminConf.get("login")).get("password").toString();

    @Override
    @Before
    public void before() throws IOException {
        super.before();
        this.requestSpecBuilder.setBaseUri(this.baseURI);
        this.requestSpecBuilder.setPort(this.port.intValue());
        this.requestSpecBuilder.setBasePath(this.basePath);
        switch (this.loginMode) {
            case SUPER: {
                String token = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().spec(this.requestSpec).body(String.format(ResourceLoader.loadFile((String)LOGIN_REQUEST_TEMPLATE), this.adminUsername, this.adminPassword, LoginType.EMAIL.getValue())).when().post(SUPER_LOGIN_REQUEST_URL, new Object[0])).then()).spec(this.responseSpec)).statusCode(200)).body("code", Matchers.equalTo((Object)1), new Object[0])).extract().path("token", new String[0]);
                this.requestSpecBuilder.addHeader("X-Access-Token", token);
                break;
            }
            case NORMAL: {
                String token = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().spec(this.requestSpec).body(String.format(ResourceLoader.loadFile((String)LOGIN_REQUEST_TEMPLATE), this.username, this.password, LoginType.EMAIL.getValue())).when().post(NORMAL_LOGIN_REQUEST_URL, new Object[0])).then()).spec(this.responseSpec)).statusCode(200)).body("code", Matchers.equalTo((Object)1), new Object[0])).extract().path("token", new String[0]);
                this.requestSpecBuilder.addHeader("X-Access-Token", token);
                break;
            }
            case NONE: {
                break;
            }
        }
        this.requestSpec = this.requestSpecBuilder.build();
    }

    public void setLoginMode(LoginMode loginMode) {
        this.loginMode = loginMode;
    }

    protected static enum LoginType {
        PHONE("1"),
        EMAIL("2");

        private final String value;

        private LoginType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    protected static enum LoginMode {
        SUPER,
        NORMAL,
        NONE;

    }
}

