package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class ChangeDeviceStatusRequest   {
    @JsonProperty("deviceId")
    private String deviceId = null;

    @JsonProperty("expireAt")
    private String expireAt = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("status")
    private String status = null;

    public ChangeDeviceStatusRequest withDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    /**
    * 设备id
    * @return deviceId
    **/
    @ApiModelProperty(value = "设备id")


    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public ChangeDeviceStatusRequest withExpireAt(String expireAt) {
        this.expireAt = expireAt;
        return this;
    }

    /**
    * 证书到期日期(yyyy/MM/dd)
    * @return expireAt
    **/
    @ApiModelProperty(value = "证书到期日期(yyyy/MM/dd)")


    public String getExpireAt() {
        return expireAt;
    }

    public void setExpireAt(String expireAt) {
        this.expireAt = expireAt;
    }

    public ChangeDeviceStatusRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public ChangeDeviceStatusRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 设备状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：停用 22：作废）
    * @return status
    **/
    @ApiModelProperty(value = "设备状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：停用 22：作废）")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ChangeDeviceStatusRequest changeDeviceStatusRequest = (ChangeDeviceStatusRequest) o;
        return Objects.equals(this.deviceId, changeDeviceStatusRequest.deviceId) &&
            Objects.equals(this.expireAt, changeDeviceStatusRequest.expireAt) &&
            Objects.equals(this.rid, changeDeviceStatusRequest.rid) &&
            Objects.equals(this.status, changeDeviceStatusRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deviceId, expireAt, rid, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link ChangeDeviceStatusRequest }.
     */
    public static ChangeDeviceStatusRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, ChangeDeviceStatusRequest.class);
    }
}

