package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 传统认证管理
 */
@ApiModel(description = "传统认证管理")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class ChangeInspectionSerOrChaFlagRequest   {
    @JsonProperty("companyId")
    private Long companyId = null;

    @JsonProperty("flag")
    private Integer flag = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("type")
    private Integer type = null;

    public ChangeInspectionSerOrChaFlagRequest withCompanyId(Long companyId) {
        this.companyId = companyId;
        return this;
    }

    /**
    * 公司id
    * @return companyId
    **/
    @ApiModelProperty(value = "公司id")


    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public ChangeInspectionSerOrChaFlagRequest withFlag(Integer flag) {
        this.flag = flag;
        return this;
    }

    /**
    * 状态
    * @return flag
    **/
    @ApiModelProperty(value = "状态")


    public Integer getFlag() {
        return flag;
    }

    public void setFlag(Integer flag) {
        this.flag = flag;
    }

    public ChangeInspectionSerOrChaFlagRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public ChangeInspectionSerOrChaFlagRequest withType(Integer type) {
        this.type = type;
        return this;
    }

    /**
    * 修改类型 (1:查验服务状态 2:极速查验通道状态)
    * @return type
    **/
    @ApiModelProperty(value = "修改类型 (1:查验服务状态 2:极速查验通道状态)")


    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ChangeInspectionSerOrChaFlagRequest changeInspectionSerOrChaFlagRequest = (ChangeInspectionSerOrChaFlagRequest) o;
        return Objects.equals(this.companyId, changeInspectionSerOrChaFlagRequest.companyId) &&
            Objects.equals(this.flag, changeInspectionSerOrChaFlagRequest.flag) &&
            Objects.equals(this.rid, changeInspectionSerOrChaFlagRequest.rid) &&
            Objects.equals(this.type, changeInspectionSerOrChaFlagRequest.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyId, flag, rid, type);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link ChangeInspectionSerOrChaFlagRequest }.
     */
    public static ChangeInspectionSerOrChaFlagRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, ChangeInspectionSerOrChaFlagRequest.class);
    }
}

