package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class CompanyChangeStatusRequest   {
    @JsonProperty("companyId")
    private String companyId = null;

    @JsonProperty("operateReason")
    private String operateReason = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("status")
    private String status = null;

    public CompanyChangeStatusRequest withCompanyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    /**
    * 自增主键
    * @return companyId
    **/
    @ApiModelProperty(value = "自增主键")


    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public CompanyChangeStatusRequest withOperateReason(String operateReason) {
        this.operateReason = operateReason;
        return this;
    }

    /**
    * 注销/启用原因
    * @return operateReason
    **/
    @ApiModelProperty(value = "注销/启用原因")


    public String getOperateReason() {
        return operateReason;
    }

    public void setOperateReason(String operateReason) {
        this.operateReason = operateReason;
    }

    public CompanyChangeStatusRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public CompanyChangeStatusRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 启用状态
    * @return status
    **/
    @ApiModelProperty(value = "启用状态")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CompanyChangeStatusRequest companyChangeStatusRequest = (CompanyChangeStatusRequest) o;
        return Objects.equals(this.companyId, companyChangeStatusRequest.companyId) &&
            Objects.equals(this.operateReason, companyChangeStatusRequest.operateReason) &&
            Objects.equals(this.rid, companyChangeStatusRequest.rid) &&
            Objects.equals(this.status, companyChangeStatusRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyId, operateReason, rid, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link CompanyChangeStatusRequest }.
     */
    public static CompanyChangeStatusRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, CompanyChangeStatusRequest.class);
    }
}

