package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 公司协同列表
 */
@ApiModel(description = "公司协同列表")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class CompanyCoordinationListRequest   {
    @JsonProperty("businessType")
    private String businessType = null;

    @JsonProperty("page")
    private String page = null;

    @JsonProperty("purchaserCompanyId")
    private String purchaserCompanyId = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private String row = null;

    @JsonProperty("sellerCompanyId")
    private String sellerCompanyId = null;

    public CompanyCoordinationListRequest withBusinessType(String businessType) {
        this.businessType = businessType;
        return this;
    }

    /**
    * 业务类型
    * @return businessType
    **/
    @ApiModelProperty(value = "业务类型")


    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public CompanyCoordinationListRequest withPage(String page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public CompanyCoordinationListRequest withPurchaserCompanyId(String purchaserCompanyId) {
        this.purchaserCompanyId = purchaserCompanyId;
        return this;
    }

    /**
    * 购方公司id
    * @return purchaserCompanyId
    **/
    @ApiModelProperty(value = "购方公司id")


    public String getPurchaserCompanyId() {
        return purchaserCompanyId;
    }

    public void setPurchaserCompanyId(String purchaserCompanyId) {
        this.purchaserCompanyId = purchaserCompanyId;
    }

    public CompanyCoordinationListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public CompanyCoordinationListRequest withRow(String row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public String getRow() {
        return row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public CompanyCoordinationListRequest withSellerCompanyId(String sellerCompanyId) {
        this.sellerCompanyId = sellerCompanyId;
        return this;
    }

    /**
    * 销方公司id
    * @return sellerCompanyId
    **/
    @ApiModelProperty(value = "销方公司id")


    public String getSellerCompanyId() {
        return sellerCompanyId;
    }

    public void setSellerCompanyId(String sellerCompanyId) {
        this.sellerCompanyId = sellerCompanyId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CompanyCoordinationListRequest companyCoordinationListRequest = (CompanyCoordinationListRequest) o;
        return Objects.equals(this.businessType, companyCoordinationListRequest.businessType) &&
            Objects.equals(this.page, companyCoordinationListRequest.page) &&
            Objects.equals(this.purchaserCompanyId, companyCoordinationListRequest.purchaserCompanyId) &&
            Objects.equals(this.rid, companyCoordinationListRequest.rid) &&
            Objects.equals(this.row, companyCoordinationListRequest.row) &&
            Objects.equals(this.sellerCompanyId, companyCoordinationListRequest.sellerCompanyId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(businessType, page, purchaserCompanyId, rid, row, sellerCompanyId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link CompanyCoordinationListRequest }.
     */
    public static CompanyCoordinationListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, CompanyCoordinationListRequest.class);
    }
}

