package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.yiwan.seiya.phoenix.bss.app.model.GroupModel;
import org.yiwan.seiya.phoenix.bss.app.model.TenantModel;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * null
 */
@ApiModel(description = "null")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class CompanyModel   {
    @JsonProperty("bankAddr")
    private String bankAddr = null;

    @JsonProperty("bankArea")
    private String bankArea = null;

    @JsonProperty("bankBranchName")
    private String bankBranchName = null;

    @JsonProperty("bankCity")
    private String bankCity = null;

    @JsonProperty("bankName")
    private String bankName = null;

    @JsonProperty("bankNo")
    private String bankNo = null;

    @JsonProperty("businessEndTime")
    private String businessEndTime = null;

    @JsonProperty("businessLicense")
    private String businessLicense = null;

    @JsonProperty("businessScope")
    private String businessScope = null;

    @JsonProperty("businessStartTime")
    private String businessStartTime = null;

    @JsonProperty("businessTimeLong")
    private String businessTimeLong = null;

    @JsonProperty("ceQuota")
    private String ceQuota = null;

    @JsonProperty("companyCode")
    private String companyCode = null;

    @JsonProperty("companyId")
    private String companyId = null;

    @JsonProperty("companyLogo")
    private String companyLogo = null;

    @JsonProperty("companyName")
    private String companyName = null;

    @JsonProperty("cquota")
    private String cquota = null;

    @JsonProperty("createTime")
    private String createTime = null;

    @JsonProperty("createUserId")
    private String createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonProperty("customerType")
    private String customerType = null;

    @JsonProperty("groupNames")
    private String groupNames = null;

    @JsonProperty("groups")
    @Valid
    private List<GroupModel> groups = null;

    @JsonProperty("inspectionServiceFlag")
    private String inspectionServiceFlag = null;

    @JsonProperty("juQuota")
    private String juQuota = null;

    @JsonProperty("locationAddr")
    private String locationAddr = null;

    @JsonProperty("locationArea")
    private String locationArea = null;

    @JsonProperty("locationCity")
    private String locationCity = null;

    @JsonProperty("managerIdCard")
    private String managerIdCard = null;

    @JsonProperty("managerIdCardBackPhoto")
    private String managerIdCardBackPhoto = null;

    @JsonProperty("managerIdCardEndTime")
    private String managerIdCardEndTime = null;

    @JsonProperty("managerIdCardFrontPhoto")
    private String managerIdCardFrontPhoto = null;

    @JsonProperty("managerIdCardStartTime")
    private String managerIdCardStartTime = null;

    @JsonProperty("managerIdCardTimeLong")
    private String managerIdCardTimeLong = null;

    @JsonProperty("managerLocation")
    private String managerLocation = null;

    @JsonProperty("managerName")
    private String managerName = null;

    @JsonProperty("managerPhone")
    private String managerPhone = null;

    @JsonProperty("operateReason")
    private String operateReason = null;

    @JsonProperty("platManagerStatus")
    private String platManagerStatus = null;

    @JsonProperty("proxyManagerIdCard")
    private String proxyManagerIdCard = null;

    @JsonProperty("proxyManagerIdCardBackPhoto")
    private String proxyManagerIdCardBackPhoto = null;

    @JsonProperty("proxyManagerIdCardEndTime")
    private String proxyManagerIdCardEndTime = null;

    @JsonProperty("proxyManagerIdCardFrontPhoto")
    private String proxyManagerIdCardFrontPhoto = null;

    @JsonProperty("proxyManagerIdCardStartTime")
    private String proxyManagerIdCardStartTime = null;

    @JsonProperty("proxyManagerIdCardTimeLong")
    private String proxyManagerIdCardTimeLong = null;

    @JsonProperty("proxyManagerName")
    private String proxyManagerName = null;

    @JsonProperty("proxyManagerPhone")
    private String proxyManagerPhone = null;

    @JsonProperty("registLocationAddr")
    private String registLocationAddr = null;

    @JsonProperty("registLocationArea")
    private String registLocationArea = null;

    @JsonProperty("registLocationCity")
    private String registLocationCity = null;

    @JsonProperty("speedInspectionChannelFlag")
    private String speedInspectionChannelFlag = null;

    @JsonProperty("squota")
    private String squota = null;

    @JsonProperty("status")
    private String status = null;

    @JsonProperty("taxNum")
    private String taxNum = null;

    @JsonProperty("taxpayerQualification")
    private String taxpayerQualification = null;

    @JsonProperty("taxpayerQualificationType")
    private String taxpayerQualificationType = null;

    @JsonProperty("tenantNames")
    private String tenantNames = null;

    @JsonProperty("tenants")
    @Valid
    private List<TenantModel> tenants = null;

    @JsonProperty("traditionAuthenFlag")
    private String traditionAuthenFlag = null;

    @JsonProperty("updateTime")
    private String updateTime = null;

    @JsonProperty("updateUserId")
    private String updateUserId = null;

    @JsonProperty("updateUserName")
    private String updateUserName = null;

    public CompanyModel withBankAddr(String bankAddr) {
        this.bankAddr = bankAddr;
        return this;
    }

    /**
    * 开户行地址
    * @return bankAddr
    **/
    @ApiModelProperty(value = "开户行地址")


    public String getBankAddr() {
        return bankAddr;
    }

    public void setBankAddr(String bankAddr) {
        this.bankAddr = bankAddr;
    }

    public CompanyModel withBankArea(String bankArea) {
        this.bankArea = bankArea;
        return this;
    }

    /**
    * 公司所在省份
    * @return bankArea
    **/
    @ApiModelProperty(value = "公司所在省份")


    public String getBankArea() {
        return bankArea;
    }

    public void setBankArea(String bankArea) {
        this.bankArea = bankArea;
    }

    public CompanyModel withBankBranchName(String bankBranchName) {
        this.bankBranchName = bankBranchName;
        return this;
    }

    /**
    * 开户银行支行名称
    * @return bankBranchName
    **/
    @ApiModelProperty(value = "开户银行支行名称")


    public String getBankBranchName() {
        return bankBranchName;
    }

    public void setBankBranchName(String bankBranchName) {
        this.bankBranchName = bankBranchName;
    }

    public CompanyModel withBankCity(String bankCity) {
        this.bankCity = bankCity;
        return this;
    }

    /**
    * 公司所在市区
    * @return bankCity
    **/
    @ApiModelProperty(value = "公司所在市区")


    public String getBankCity() {
        return bankCity;
    }

    public void setBankCity(String bankCity) {
        this.bankCity = bankCity;
    }

    public CompanyModel withBankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    /**
    * 开户行名称
    * @return bankName
    **/
    @ApiModelProperty(value = "开户行名称")


    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public CompanyModel withBankNo(String bankNo) {
        this.bankNo = bankNo;
        return this;
    }

    /**
    * 对公银行账户
    * @return bankNo
    **/
    @ApiModelProperty(value = "对公银行账户")


    public String getBankNo() {
        return bankNo;
    }

    public void setBankNo(String bankNo) {
        this.bankNo = bankNo;
    }

    public CompanyModel withBusinessEndTime(String businessEndTime) {
        this.businessEndTime = businessEndTime;
        return this;
    }

    /**
    * 营业期限结束时间
    * @return businessEndTime
    **/
    @ApiModelProperty(value = "营业期限结束时间")


    public String getBusinessEndTime() {
        return businessEndTime;
    }

    public void setBusinessEndTime(String businessEndTime) {
        this.businessEndTime = businessEndTime;
    }

    public CompanyModel withBusinessLicense(String businessLicense) {
        this.businessLicense = businessLicense;
        return this;
    }

    /**
    * 营业执照影像
    * @return businessLicense
    **/
    @ApiModelProperty(value = "营业执照影像")


    public String getBusinessLicense() {
        return businessLicense;
    }

    public void setBusinessLicense(String businessLicense) {
        this.businessLicense = businessLicense;
    }

    public CompanyModel withBusinessScope(String businessScope) {
        this.businessScope = businessScope;
        return this;
    }

    /**
    * 企业经营范围
    * @return businessScope
    **/
    @ApiModelProperty(value = "企业经营范围")


    public String getBusinessScope() {
        return businessScope;
    }

    public void setBusinessScope(String businessScope) {
        this.businessScope = businessScope;
    }

    public CompanyModel withBusinessStartTime(String businessStartTime) {
        this.businessStartTime = businessStartTime;
        return this;
    }

    /**
    * 营业期限开始时间
    * @return businessStartTime
    **/
    @ApiModelProperty(value = "营业期限开始时间")


    public String getBusinessStartTime() {
        return businessStartTime;
    }

    public void setBusinessStartTime(String businessStartTime) {
        this.businessStartTime = businessStartTime;
    }

    public CompanyModel withBusinessTimeLong(String businessTimeLong) {
        this.businessTimeLong = businessTimeLong;
        return this;
    }

    /**
    * 营业期限时间是否长期 1：是 0：否
    * @return businessTimeLong
    **/
    @ApiModelProperty(value = "营业期限时间是否长期 1：是 0：否")


    public String getBusinessTimeLong() {
        return businessTimeLong;
    }

    public void setBusinessTimeLong(String businessTimeLong) {
        this.businessTimeLong = businessTimeLong;
    }

    public CompanyModel withCeQuota(String ceQuota) {
        this.ceQuota = ceQuota;
        return this;
    }

    /**
    * 增值税电子普通发票限额
    * @return ceQuota
    **/
    @ApiModelProperty(value = "增值税电子普通发票限额")


    public String getCeQuota() {
        return ceQuota;
    }

    public void setCeQuota(String ceQuota) {
        this.ceQuota = ceQuota;
    }

    public CompanyModel withCompanyCode(String companyCode) {
        this.companyCode = companyCode;
        return this;
    }

    /**
    * 企业编码
    * @return companyCode
    **/
    @ApiModelProperty(value = "企业编码")


    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public CompanyModel withCompanyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    /**
    * 自增主键
    * @return companyId
    **/
    @ApiModelProperty(value = "自增主键")


    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public CompanyModel withCompanyLogo(String companyLogo) {
        this.companyLogo = companyLogo;
        return this;
    }

    /**
    * 企业Logo
    * @return companyLogo
    **/
    @ApiModelProperty(value = "企业Logo")


    public String getCompanyLogo() {
        return companyLogo;
    }

    public void setCompanyLogo(String companyLogo) {
        this.companyLogo = companyLogo;
    }

    public CompanyModel withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    /**
    * 企业名称
    * @return companyName
    **/
    @ApiModelProperty(value = "企业名称")


    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public CompanyModel withCquota(String cquota) {
        this.cquota = cquota;
        return this;
    }

    /**
    * 增值税普通发票限额
    * @return cquota
    **/
    @ApiModelProperty(value = "增值税普通发票限额")


    public String getCquota() {
        return cquota;
    }

    public void setCquota(String cquota) {
        this.cquota = cquota;
    }

    public CompanyModel withCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
    * 创建时间
    * @return createTime
    **/
    @ApiModelProperty(value = "创建时间")


    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public CompanyModel withCreateUserId(String createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    /**
    * 创建人ID
    * @return createUserId
    **/
    @ApiModelProperty(value = "创建人ID")


    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public CompanyModel withCreateUserName(String createUserName) {
        this.createUserName = createUserName;
        return this;
    }

    /**
    * 创建人姓名
    * @return createUserName
    **/
    @ApiModelProperty(value = "创建人姓名")


    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public CompanyModel withCustomerType(String customerType) {
        this.customerType = customerType;
        return this;
    }

    /**
    * 客户类型 1：VIP客户 0：一般客户
    * @return customerType
    **/
    @ApiModelProperty(value = "客户类型 1：VIP客户 0：一般客户")


    public String getCustomerType() {
        return customerType;
    }

    public void setCustomerType(String customerType) {
        this.customerType = customerType;
    }

    public CompanyModel withGroupNames(String groupNames) {
        this.groupNames = groupNames;
        return this;
    }

    /**
    * 集团名称 ,号隔开
    * @return groupNames
    **/
    @ApiModelProperty(value = "集团名称 ,号隔开")


    public String getGroupNames() {
        return groupNames;
    }

    public void setGroupNames(String groupNames) {
        this.groupNames = groupNames;
    }

    public CompanyModel withGroups(List<GroupModel> groups) {
        this.groups = groups;
        return this;
    }

    public CompanyModel withGroupsAdd(GroupModel groups) {
        if (this.groups == null) {
            this.groups = new ArrayList<GroupModel>();
        }
        this.groups.add(groups);
        return this;
    }

    /**
    * 集团列表
    * @return groups
    **/
    @ApiModelProperty(value = "集团列表")

  @Valid

    public List<GroupModel> getGroups() {
        return groups;
    }

    public void setGroups(List<GroupModel> groups) {
        this.groups = groups;
    }

    public CompanyModel withInspectionServiceFlag(String inspectionServiceFlag) {
        this.inspectionServiceFlag = inspectionServiceFlag;
        return this;
    }

    /**
    * 查验服务状态(1:开启；0:关闭)
    * @return inspectionServiceFlag
    **/
    @ApiModelProperty(value = "查验服务状态(1:开启；0:关闭)")


    public String getInspectionServiceFlag() {
        return inspectionServiceFlag;
    }

    public void setInspectionServiceFlag(String inspectionServiceFlag) {
        this.inspectionServiceFlag = inspectionServiceFlag;
    }

    public CompanyModel withJuQuota(String juQuota) {
        this.juQuota = juQuota;
        return this;
    }

    /**
    * 增值税普通发票(卷票）限额
    * @return juQuota
    **/
    @ApiModelProperty(value = "增值税普通发票(卷票）限额")


    public String getJuQuota() {
        return juQuota;
    }

    public void setJuQuota(String juQuota) {
        this.juQuota = juQuota;
    }

    public CompanyModel withLocationAddr(String locationAddr) {
        this.locationAddr = locationAddr;
        return this;
    }

    /**
    * 公司经营所在详细地址
    * @return locationAddr
    **/
    @ApiModelProperty(value = "公司经营所在详细地址")


    public String getLocationAddr() {
        return locationAddr;
    }

    public void setLocationAddr(String locationAddr) {
        this.locationAddr = locationAddr;
    }

    public CompanyModel withLocationArea(String locationArea) {
        this.locationArea = locationArea;
        return this;
    }

    /**
    * 公司经营所在省份
    * @return locationArea
    **/
    @ApiModelProperty(value = "公司经营所在省份")


    public String getLocationArea() {
        return locationArea;
    }

    public void setLocationArea(String locationArea) {
        this.locationArea = locationArea;
    }

    public CompanyModel withLocationCity(String locationCity) {
        this.locationCity = locationCity;
        return this;
    }

    /**
    * 公司经营所在市区
    * @return locationCity
    **/
    @ApiModelProperty(value = "公司经营所在市区")


    public String getLocationCity() {
        return locationCity;
    }

    public void setLocationCity(String locationCity) {
        this.locationCity = locationCity;
    }

    public CompanyModel withManagerIdCard(String managerIdCard) {
        this.managerIdCard = managerIdCard;
        return this;
    }

    /**
    * 法人身份证
    * @return managerIdCard
    **/
    @ApiModelProperty(value = "法人身份证")


    public String getManagerIdCard() {
        return managerIdCard;
    }

    public void setManagerIdCard(String managerIdCard) {
        this.managerIdCard = managerIdCard;
    }

    public CompanyModel withManagerIdCardBackPhoto(String managerIdCardBackPhoto) {
        this.managerIdCardBackPhoto = managerIdCardBackPhoto;
        return this;
    }

    /**
    * 法人证件背面照
    * @return managerIdCardBackPhoto
    **/
    @ApiModelProperty(value = "法人证件背面照")


    public String getManagerIdCardBackPhoto() {
        return managerIdCardBackPhoto;
    }

    public void setManagerIdCardBackPhoto(String managerIdCardBackPhoto) {
        this.managerIdCardBackPhoto = managerIdCardBackPhoto;
    }

    public CompanyModel withManagerIdCardEndTime(String managerIdCardEndTime) {
        this.managerIdCardEndTime = managerIdCardEndTime;
        return this;
    }

    /**
    * 法人证件结束时间
    * @return managerIdCardEndTime
    **/
    @ApiModelProperty(value = "法人证件结束时间")


    public String getManagerIdCardEndTime() {
        return managerIdCardEndTime;
    }

    public void setManagerIdCardEndTime(String managerIdCardEndTime) {
        this.managerIdCardEndTime = managerIdCardEndTime;
    }

    public CompanyModel withManagerIdCardFrontPhoto(String managerIdCardFrontPhoto) {
        this.managerIdCardFrontPhoto = managerIdCardFrontPhoto;
        return this;
    }

    /**
    * 法人证件正面照
    * @return managerIdCardFrontPhoto
    **/
    @ApiModelProperty(value = "法人证件正面照")


    public String getManagerIdCardFrontPhoto() {
        return managerIdCardFrontPhoto;
    }

    public void setManagerIdCardFrontPhoto(String managerIdCardFrontPhoto) {
        this.managerIdCardFrontPhoto = managerIdCardFrontPhoto;
    }

    public CompanyModel withManagerIdCardStartTime(String managerIdCardStartTime) {
        this.managerIdCardStartTime = managerIdCardStartTime;
        return this;
    }

    /**
    * 法人证件开始时间
    * @return managerIdCardStartTime
    **/
    @ApiModelProperty(value = "法人证件开始时间")


    public String getManagerIdCardStartTime() {
        return managerIdCardStartTime;
    }

    public void setManagerIdCardStartTime(String managerIdCardStartTime) {
        this.managerIdCardStartTime = managerIdCardStartTime;
    }

    public CompanyModel withManagerIdCardTimeLong(String managerIdCardTimeLong) {
        this.managerIdCardTimeLong = managerIdCardTimeLong;
        return this;
    }

    /**
    * 代表人证件时间是否长期 1：是 0：否
    * @return managerIdCardTimeLong
    **/
    @ApiModelProperty(value = "代表人证件时间是否长期 1：是 0：否")


    public String getManagerIdCardTimeLong() {
        return managerIdCardTimeLong;
    }

    public void setManagerIdCardTimeLong(String managerIdCardTimeLong) {
        this.managerIdCardTimeLong = managerIdCardTimeLong;
    }

    public CompanyModel withManagerLocation(String managerLocation) {
        this.managerLocation = managerLocation;
        return this;
    }

    /**
    * 法人归属地
    * @return managerLocation
    **/
    @ApiModelProperty(value = "法人归属地")


    public String getManagerLocation() {
        return managerLocation;
    }

    public void setManagerLocation(String managerLocation) {
        this.managerLocation = managerLocation;
    }

    public CompanyModel withManagerName(String managerName) {
        this.managerName = managerName;
        return this;
    }

    /**
    * 法人姓名
    * @return managerName
    **/
    @ApiModelProperty(value = "法人姓名")


    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    public CompanyModel withManagerPhone(String managerPhone) {
        this.managerPhone = managerPhone;
        return this;
    }

    /**
    * 法人联系方式
    * @return managerPhone
    **/
    @ApiModelProperty(value = "法人联系方式")


    public String getManagerPhone() {
        return managerPhone;
    }

    public void setManagerPhone(String managerPhone) {
        this.managerPhone = managerPhone;
    }

    public CompanyModel withOperateReason(String operateReason) {
        this.operateReason = operateReason;
        return this;
    }

    /**
    * 注销/启用原因
    * @return operateReason
    **/
    @ApiModelProperty(value = "注销/启用原因")


    public String getOperateReason() {
        return operateReason;
    }

    public void setOperateReason(String operateReason) {
        this.operateReason = operateReason;
    }

    public CompanyModel withPlatManagerStatus(String platManagerStatus) {
        this.platManagerStatus = platManagerStatus;
        return this;
    }

    /**
    * 平台管理人身份 0：法定代表人 1：代理人
    * @return platManagerStatus
    **/
    @ApiModelProperty(value = "平台管理人身份 0：法定代表人 1：代理人")


    public String getPlatManagerStatus() {
        return platManagerStatus;
    }

    public void setPlatManagerStatus(String platManagerStatus) {
        this.platManagerStatus = platManagerStatus;
    }

    public CompanyModel withProxyManagerIdCard(String proxyManagerIdCard) {
        this.proxyManagerIdCard = proxyManagerIdCard;
        return this;
    }

    /**
    * 代理人身份证
    * @return proxyManagerIdCard
    **/
    @ApiModelProperty(value = "代理人身份证")


    public String getProxyManagerIdCard() {
        return proxyManagerIdCard;
    }

    public void setProxyManagerIdCard(String proxyManagerIdCard) {
        this.proxyManagerIdCard = proxyManagerIdCard;
    }

    public CompanyModel withProxyManagerIdCardBackPhoto(String proxyManagerIdCardBackPhoto) {
        this.proxyManagerIdCardBackPhoto = proxyManagerIdCardBackPhoto;
        return this;
    }

    /**
    * 代理人证件背面照
    * @return proxyManagerIdCardBackPhoto
    **/
    @ApiModelProperty(value = "代理人证件背面照")


    public String getProxyManagerIdCardBackPhoto() {
        return proxyManagerIdCardBackPhoto;
    }

    public void setProxyManagerIdCardBackPhoto(String proxyManagerIdCardBackPhoto) {
        this.proxyManagerIdCardBackPhoto = proxyManagerIdCardBackPhoto;
    }

    public CompanyModel withProxyManagerIdCardEndTime(String proxyManagerIdCardEndTime) {
        this.proxyManagerIdCardEndTime = proxyManagerIdCardEndTime;
        return this;
    }

    /**
    * 代理人证件结束时间
    * @return proxyManagerIdCardEndTime
    **/
    @ApiModelProperty(value = "代理人证件结束时间")


    public String getProxyManagerIdCardEndTime() {
        return proxyManagerIdCardEndTime;
    }

    public void setProxyManagerIdCardEndTime(String proxyManagerIdCardEndTime) {
        this.proxyManagerIdCardEndTime = proxyManagerIdCardEndTime;
    }

    public CompanyModel withProxyManagerIdCardFrontPhoto(String proxyManagerIdCardFrontPhoto) {
        this.proxyManagerIdCardFrontPhoto = proxyManagerIdCardFrontPhoto;
        return this;
    }

    /**
    * 代理人证件正面照
    * @return proxyManagerIdCardFrontPhoto
    **/
    @ApiModelProperty(value = "代理人证件正面照")


    public String getProxyManagerIdCardFrontPhoto() {
        return proxyManagerIdCardFrontPhoto;
    }

    public void setProxyManagerIdCardFrontPhoto(String proxyManagerIdCardFrontPhoto) {
        this.proxyManagerIdCardFrontPhoto = proxyManagerIdCardFrontPhoto;
    }

    public CompanyModel withProxyManagerIdCardStartTime(String proxyManagerIdCardStartTime) {
        this.proxyManagerIdCardStartTime = proxyManagerIdCardStartTime;
        return this;
    }

    /**
    * 代理人证件开始时间
    * @return proxyManagerIdCardStartTime
    **/
    @ApiModelProperty(value = "代理人证件开始时间")


    public String getProxyManagerIdCardStartTime() {
        return proxyManagerIdCardStartTime;
    }

    public void setProxyManagerIdCardStartTime(String proxyManagerIdCardStartTime) {
        this.proxyManagerIdCardStartTime = proxyManagerIdCardStartTime;
    }

    public CompanyModel withProxyManagerIdCardTimeLong(String proxyManagerIdCardTimeLong) {
        this.proxyManagerIdCardTimeLong = proxyManagerIdCardTimeLong;
        return this;
    }

    /**
    * 代理人证件时间是否长期 1：是 0：否
    * @return proxyManagerIdCardTimeLong
    **/
    @ApiModelProperty(value = "代理人证件时间是否长期 1：是 0：否")


    public String getProxyManagerIdCardTimeLong() {
        return proxyManagerIdCardTimeLong;
    }

    public void setProxyManagerIdCardTimeLong(String proxyManagerIdCardTimeLong) {
        this.proxyManagerIdCardTimeLong = proxyManagerIdCardTimeLong;
    }

    public CompanyModel withProxyManagerName(String proxyManagerName) {
        this.proxyManagerName = proxyManagerName;
        return this;
    }

    /**
    * 代理人姓名
    * @return proxyManagerName
    **/
    @ApiModelProperty(value = "代理人姓名")


    public String getProxyManagerName() {
        return proxyManagerName;
    }

    public void setProxyManagerName(String proxyManagerName) {
        this.proxyManagerName = proxyManagerName;
    }

    public CompanyModel withProxyManagerPhone(String proxyManagerPhone) {
        this.proxyManagerPhone = proxyManagerPhone;
        return this;
    }

    /**
    * 代理人联系方式
    * @return proxyManagerPhone
    **/
    @ApiModelProperty(value = "代理人联系方式")


    public String getProxyManagerPhone() {
        return proxyManagerPhone;
    }

    public void setProxyManagerPhone(String proxyManagerPhone) {
        this.proxyManagerPhone = proxyManagerPhone;
    }

    public CompanyModel withRegistLocationAddr(String registLocationAddr) {
        this.registLocationAddr = registLocationAddr;
        return this;
    }

    /**
    * 公司注册所在详细地址
    * @return registLocationAddr
    **/
    @ApiModelProperty(value = "公司注册所在详细地址")


    public String getRegistLocationAddr() {
        return registLocationAddr;
    }

    public void setRegistLocationAddr(String registLocationAddr) {
        this.registLocationAddr = registLocationAddr;
    }

    public CompanyModel withRegistLocationArea(String registLocationArea) {
        this.registLocationArea = registLocationArea;
        return this;
    }

    /**
    * 公司注册所在省份
    * @return registLocationArea
    **/
    @ApiModelProperty(value = "公司注册所在省份")


    public String getRegistLocationArea() {
        return registLocationArea;
    }

    public void setRegistLocationArea(String registLocationArea) {
        this.registLocationArea = registLocationArea;
    }

    public CompanyModel withRegistLocationCity(String registLocationCity) {
        this.registLocationCity = registLocationCity;
        return this;
    }

    /**
    * 公司注册所在市区
    * @return registLocationCity
    **/
    @ApiModelProperty(value = "公司注册所在市区")


    public String getRegistLocationCity() {
        return registLocationCity;
    }

    public void setRegistLocationCity(String registLocationCity) {
        this.registLocationCity = registLocationCity;
    }

    public CompanyModel withSpeedInspectionChannelFlag(String speedInspectionChannelFlag) {
        this.speedInspectionChannelFlag = speedInspectionChannelFlag;
        return this;
    }

    /**
    * 极速查验通道状态(1:开启；0:关闭)
    * @return speedInspectionChannelFlag
    **/
    @ApiModelProperty(value = "极速查验通道状态(1:开启；0:关闭)")


    public String getSpeedInspectionChannelFlag() {
        return speedInspectionChannelFlag;
    }

    public void setSpeedInspectionChannelFlag(String speedInspectionChannelFlag) {
        this.speedInspectionChannelFlag = speedInspectionChannelFlag;
    }

    public CompanyModel withSquota(String squota) {
        this.squota = squota;
        return this;
    }

    /**
    * 增值税专用发票限额
    * @return squota
    **/
    @ApiModelProperty(value = "增值税专用发票限额")


    public String getSquota() {
        return squota;
    }

    public void setSquota(String squota) {
        this.squota = squota;
    }

    public CompanyModel withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 启用状态： 1：启用 0：注销
    * @return status
    **/
    @ApiModelProperty(value = "启用状态： 1：启用 0：注销")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public CompanyModel withTaxNum(String taxNum) {
        this.taxNum = taxNum;
        return this;
    }

    /**
    * 税号
    * @return taxNum
    **/
    @ApiModelProperty(value = "税号")


    public String getTaxNum() {
        return taxNum;
    }

    public void setTaxNum(String taxNum) {
        this.taxNum = taxNum;
    }

    public CompanyModel withTaxpayerQualification(String taxpayerQualification) {
        this.taxpayerQualification = taxpayerQualification;
        return this;
    }

    /**
    * 纳税人资质证书
    * @return taxpayerQualification
    **/
    @ApiModelProperty(value = "纳税人资质证书")


    public String getTaxpayerQualification() {
        return taxpayerQualification;
    }

    public void setTaxpayerQualification(String taxpayerQualification) {
        this.taxpayerQualification = taxpayerQualification;
    }

    public CompanyModel withTaxpayerQualificationType(String taxpayerQualificationType) {
        this.taxpayerQualificationType = taxpayerQualificationType;
        return this;
    }

    /**
    * 纳税人资质类型 1:一般增值税纳税人 2:小规模纳税人
    * @return taxpayerQualificationType
    **/
    @ApiModelProperty(value = "纳税人资质类型 1:一般增值税纳税人 2:小规模纳税人")


    public String getTaxpayerQualificationType() {
        return taxpayerQualificationType;
    }

    public void setTaxpayerQualificationType(String taxpayerQualificationType) {
        this.taxpayerQualificationType = taxpayerQualificationType;
    }

    public CompanyModel withTenantNames(String tenantNames) {
        this.tenantNames = tenantNames;
        return this;
    }

    /**
    * 租户名称 ,号隔开
    * @return tenantNames
    **/
    @ApiModelProperty(value = "租户名称 ,号隔开")


    public String getTenantNames() {
        return tenantNames;
    }

    public void setTenantNames(String tenantNames) {
        this.tenantNames = tenantNames;
    }

    public CompanyModel withTenants(List<TenantModel> tenants) {
        this.tenants = tenants;
        return this;
    }

    public CompanyModel withTenantsAdd(TenantModel tenants) {
        if (this.tenants == null) {
            this.tenants = new ArrayList<TenantModel>();
        }
        this.tenants.add(tenants);
        return this;
    }

    /**
    * 租户列表
    * @return tenants
    **/
    @ApiModelProperty(value = "租户列表")

  @Valid

    public List<TenantModel> getTenants() {
        return tenants;
    }

    public void setTenants(List<TenantModel> tenants) {
        this.tenants = tenants;
    }

    public CompanyModel withTraditionAuthenFlag(String traditionAuthenFlag) {
        this.traditionAuthenFlag = traditionAuthenFlag;
        return this;
    }

    /**
    * 传统认证管理状态(1:开启；0:关闭)
    * @return traditionAuthenFlag
    **/
    @ApiModelProperty(value = "传统认证管理状态(1:开启；0:关闭)")


    public String getTraditionAuthenFlag() {
        return traditionAuthenFlag;
    }

    public void setTraditionAuthenFlag(String traditionAuthenFlag) {
        this.traditionAuthenFlag = traditionAuthenFlag;
    }

    public CompanyModel withUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    /**
    * 更新时间
    * @return updateTime
    **/
    @ApiModelProperty(value = "更新时间")


    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public CompanyModel withUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
        return this;
    }

    /**
    * 更新人ID
    * @return updateUserId
    **/
    @ApiModelProperty(value = "更新人ID")


    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
    }

    public CompanyModel withUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
        return this;
    }

    /**
    * 更新人姓名
    * @return updateUserName
    **/
    @ApiModelProperty(value = "更新人姓名")


    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CompanyModel companyModel = (CompanyModel) o;
        return Objects.equals(this.bankAddr, companyModel.bankAddr) &&
            Objects.equals(this.bankArea, companyModel.bankArea) &&
            Objects.equals(this.bankBranchName, companyModel.bankBranchName) &&
            Objects.equals(this.bankCity, companyModel.bankCity) &&
            Objects.equals(this.bankName, companyModel.bankName) &&
            Objects.equals(this.bankNo, companyModel.bankNo) &&
            Objects.equals(this.businessEndTime, companyModel.businessEndTime) &&
            Objects.equals(this.businessLicense, companyModel.businessLicense) &&
            Objects.equals(this.businessScope, companyModel.businessScope) &&
            Objects.equals(this.businessStartTime, companyModel.businessStartTime) &&
            Objects.equals(this.businessTimeLong, companyModel.businessTimeLong) &&
            Objects.equals(this.ceQuota, companyModel.ceQuota) &&
            Objects.equals(this.companyCode, companyModel.companyCode) &&
            Objects.equals(this.companyId, companyModel.companyId) &&
            Objects.equals(this.companyLogo, companyModel.companyLogo) &&
            Objects.equals(this.companyName, companyModel.companyName) &&
            Objects.equals(this.cquota, companyModel.cquota) &&
            Objects.equals(this.createTime, companyModel.createTime) &&
            Objects.equals(this.createUserId, companyModel.createUserId) &&
            Objects.equals(this.createUserName, companyModel.createUserName) &&
            Objects.equals(this.customerType, companyModel.customerType) &&
            Objects.equals(this.groupNames, companyModel.groupNames) &&
            Objects.equals(this.groups, companyModel.groups) &&
            Objects.equals(this.inspectionServiceFlag, companyModel.inspectionServiceFlag) &&
            Objects.equals(this.juQuota, companyModel.juQuota) &&
            Objects.equals(this.locationAddr, companyModel.locationAddr) &&
            Objects.equals(this.locationArea, companyModel.locationArea) &&
            Objects.equals(this.locationCity, companyModel.locationCity) &&
            Objects.equals(this.managerIdCard, companyModel.managerIdCard) &&
            Objects.equals(this.managerIdCardBackPhoto, companyModel.managerIdCardBackPhoto) &&
            Objects.equals(this.managerIdCardEndTime, companyModel.managerIdCardEndTime) &&
            Objects.equals(this.managerIdCardFrontPhoto, companyModel.managerIdCardFrontPhoto) &&
            Objects.equals(this.managerIdCardStartTime, companyModel.managerIdCardStartTime) &&
            Objects.equals(this.managerIdCardTimeLong, companyModel.managerIdCardTimeLong) &&
            Objects.equals(this.managerLocation, companyModel.managerLocation) &&
            Objects.equals(this.managerName, companyModel.managerName) &&
            Objects.equals(this.managerPhone, companyModel.managerPhone) &&
            Objects.equals(this.operateReason, companyModel.operateReason) &&
            Objects.equals(this.platManagerStatus, companyModel.platManagerStatus) &&
            Objects.equals(this.proxyManagerIdCard, companyModel.proxyManagerIdCard) &&
            Objects.equals(this.proxyManagerIdCardBackPhoto, companyModel.proxyManagerIdCardBackPhoto) &&
            Objects.equals(this.proxyManagerIdCardEndTime, companyModel.proxyManagerIdCardEndTime) &&
            Objects.equals(this.proxyManagerIdCardFrontPhoto, companyModel.proxyManagerIdCardFrontPhoto) &&
            Objects.equals(this.proxyManagerIdCardStartTime, companyModel.proxyManagerIdCardStartTime) &&
            Objects.equals(this.proxyManagerIdCardTimeLong, companyModel.proxyManagerIdCardTimeLong) &&
            Objects.equals(this.proxyManagerName, companyModel.proxyManagerName) &&
            Objects.equals(this.proxyManagerPhone, companyModel.proxyManagerPhone) &&
            Objects.equals(this.registLocationAddr, companyModel.registLocationAddr) &&
            Objects.equals(this.registLocationArea, companyModel.registLocationArea) &&
            Objects.equals(this.registLocationCity, companyModel.registLocationCity) &&
            Objects.equals(this.speedInspectionChannelFlag, companyModel.speedInspectionChannelFlag) &&
            Objects.equals(this.squota, companyModel.squota) &&
            Objects.equals(this.status, companyModel.status) &&
            Objects.equals(this.taxNum, companyModel.taxNum) &&
            Objects.equals(this.taxpayerQualification, companyModel.taxpayerQualification) &&
            Objects.equals(this.taxpayerQualificationType, companyModel.taxpayerQualificationType) &&
            Objects.equals(this.tenantNames, companyModel.tenantNames) &&
            Objects.equals(this.tenants, companyModel.tenants) &&
            Objects.equals(this.traditionAuthenFlag, companyModel.traditionAuthenFlag) &&
            Objects.equals(this.updateTime, companyModel.updateTime) &&
            Objects.equals(this.updateUserId, companyModel.updateUserId) &&
            Objects.equals(this.updateUserName, companyModel.updateUserName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(bankAddr, bankArea, bankBranchName, bankCity, bankName, bankNo, businessEndTime, businessLicense, businessScope, businessStartTime, businessTimeLong, ceQuota, companyCode, companyId, companyLogo, companyName, cquota, createTime, createUserId, createUserName, customerType, groupNames, groups, inspectionServiceFlag, juQuota, locationAddr, locationArea, locationCity, managerIdCard, managerIdCardBackPhoto, managerIdCardEndTime, managerIdCardFrontPhoto, managerIdCardStartTime, managerIdCardTimeLong, managerLocation, managerName, managerPhone, operateReason, platManagerStatus, proxyManagerIdCard, proxyManagerIdCardBackPhoto, proxyManagerIdCardEndTime, proxyManagerIdCardFrontPhoto, proxyManagerIdCardStartTime, proxyManagerIdCardTimeLong, proxyManagerName, proxyManagerPhone, registLocationAddr, registLocationArea, registLocationCity, speedInspectionChannelFlag, squota, status, taxNum, taxpayerQualification, taxpayerQualificationType, tenantNames, tenants, traditionAuthenFlag, updateTime, updateUserId, updateUserName);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link CompanyModel }.
     */
    public static CompanyModel fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, CompanyModel.class);
    }
}

