package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 企业新增请求对象
 */
@ApiModel(description = "企业新增请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class CompanyModifyRequest   {
    @JsonProperty("bankAddr")
    private String bankAddr = null;

    @JsonProperty("bankArea")
    private String bankArea = null;

    @JsonProperty("bankBranchName")
    private String bankBranchName = null;

    @JsonProperty("bankCity")
    private String bankCity = null;

    @JsonProperty("bankName")
    private String bankName = null;

    @JsonProperty("bankNo")
    private String bankNo = null;

    @JsonProperty("businessEndTime")
    private String businessEndTime = null;

    @JsonProperty("businessLicense")
    private String businessLicense = null;

    @JsonProperty("businessScope")
    private String businessScope = null;

    @JsonProperty("businessStartTime")
    private String businessStartTime = null;

    @JsonProperty("businessTimeLong")
    private String businessTimeLong = null;

    @JsonProperty("ceQuota")
    private String ceQuota = null;

    @JsonProperty("companyId")
    private String companyId = null;

    @JsonProperty("companyName")
    private String companyName = null;

    @JsonProperty("cquota")
    private String cquota = null;

    @JsonProperty("customerType")
    private String customerType = null;

    @JsonProperty("groupId")
    private String groupId = null;

    @JsonProperty("juQuota")
    private String juQuota = null;

    @JsonProperty("locationAddr")
    private String locationAddr = null;

    @JsonProperty("locationArea")
    private String locationArea = null;

    @JsonProperty("locationCity")
    private String locationCity = null;

    @JsonProperty("managerIdCard")
    private String managerIdCard = null;

    @JsonProperty("managerIdCardBackPhoto")
    private String managerIdCardBackPhoto = null;

    @JsonProperty("managerIdCardEndTime")
    private String managerIdCardEndTime = null;

    @JsonProperty("managerIdCardFrontPhoto")
    private String managerIdCardFrontPhoto = null;

    @JsonProperty("managerIdCardStartTime")
    private String managerIdCardStartTime = null;

    @JsonProperty("managerIdCardTimeLong")
    private String managerIdCardTimeLong = null;

    @JsonProperty("managerLocation")
    private String managerLocation = null;

    @JsonProperty("managerName")
    private String managerName = null;

    @JsonProperty("managerPhone")
    private String managerPhone = null;

    @JsonProperty("platManagerStatus")
    private String platManagerStatus = null;

    @JsonProperty("proxyManagerIdCard")
    private String proxyManagerIdCard = null;

    @JsonProperty("proxyManagerIdCardBackPhoto")
    private String proxyManagerIdCardBackPhoto = null;

    @JsonProperty("proxyManagerIdCardEndTime")
    private String proxyManagerIdCardEndTime = null;

    @JsonProperty("proxyManagerIdCardFrontPhoto")
    private String proxyManagerIdCardFrontPhoto = null;

    @JsonProperty("proxyManagerIdCardStartTime")
    private String proxyManagerIdCardStartTime = null;

    @JsonProperty("proxyManagerIdCardTimeLong")
    private String proxyManagerIdCardTimeLong = null;

    @JsonProperty("proxyManagerName")
    private String proxyManagerName = null;

    @JsonProperty("proxyManagerPhone")
    private String proxyManagerPhone = null;

    @JsonProperty("registLocationAddr")
    private String registLocationAddr = null;

    @JsonProperty("registLocationArea")
    private String registLocationArea = null;

    @JsonProperty("registLocationCity")
    private String registLocationCity = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("squota")
    private String squota = null;

    @JsonProperty("taxpayerQualification")
    private String taxpayerQualification = null;

    @JsonProperty("taxpayerQualificationType")
    private String taxpayerQualificationType = null;

    @JsonProperty("tenantId")
    private String tenantId = null;

    public CompanyModifyRequest withBankAddr(String bankAddr) {
        this.bankAddr = bankAddr;
        return this;
    }

    /**
    * 开户行地址
    * @return bankAddr
    **/
    @ApiModelProperty(value = "开户行地址")


    public String getBankAddr() {
        return bankAddr;
    }

    public void setBankAddr(String bankAddr) {
        this.bankAddr = bankAddr;
    }

    public CompanyModifyRequest withBankArea(String bankArea) {
        this.bankArea = bankArea;
        return this;
    }

    /**
    * 公司所在省份
    * @return bankArea
    **/
    @ApiModelProperty(value = "公司所在省份")


    public String getBankArea() {
        return bankArea;
    }

    public void setBankArea(String bankArea) {
        this.bankArea = bankArea;
    }

    public CompanyModifyRequest withBankBranchName(String bankBranchName) {
        this.bankBranchName = bankBranchName;
        return this;
    }

    /**
    * 开户银行支行名称
    * @return bankBranchName
    **/
    @ApiModelProperty(value = "开户银行支行名称")


    public String getBankBranchName() {
        return bankBranchName;
    }

    public void setBankBranchName(String bankBranchName) {
        this.bankBranchName = bankBranchName;
    }

    public CompanyModifyRequest withBankCity(String bankCity) {
        this.bankCity = bankCity;
        return this;
    }

    /**
    * 公司所在市区
    * @return bankCity
    **/
    @ApiModelProperty(value = "公司所在市区")


    public String getBankCity() {
        return bankCity;
    }

    public void setBankCity(String bankCity) {
        this.bankCity = bankCity;
    }

    public CompanyModifyRequest withBankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    /**
    * 开户行名称
    * @return bankName
    **/
    @ApiModelProperty(value = "开户行名称")


    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public CompanyModifyRequest withBankNo(String bankNo) {
        this.bankNo = bankNo;
        return this;
    }

    /**
    * 对公银行账户
    * @return bankNo
    **/
    @ApiModelProperty(value = "对公银行账户")


    public String getBankNo() {
        return bankNo;
    }

    public void setBankNo(String bankNo) {
        this.bankNo = bankNo;
    }

    public CompanyModifyRequest withBusinessEndTime(String businessEndTime) {
        this.businessEndTime = businessEndTime;
        return this;
    }

    /**
    * 营业期限结束时间
    * @return businessEndTime
    **/
    @ApiModelProperty(value = "营业期限结束时间")


    public String getBusinessEndTime() {
        return businessEndTime;
    }

    public void setBusinessEndTime(String businessEndTime) {
        this.businessEndTime = businessEndTime;
    }

    public CompanyModifyRequest withBusinessLicense(String businessLicense) {
        this.businessLicense = businessLicense;
        return this;
    }

    /**
    * 营业执照影像
    * @return businessLicense
    **/
    @ApiModelProperty(value = "营业执照影像")


    public String getBusinessLicense() {
        return businessLicense;
    }

    public void setBusinessLicense(String businessLicense) {
        this.businessLicense = businessLicense;
    }

    public CompanyModifyRequest withBusinessScope(String businessScope) {
        this.businessScope = businessScope;
        return this;
    }

    /**
    * 企业经营范围
    * @return businessScope
    **/
    @ApiModelProperty(value = "企业经营范围")


    public String getBusinessScope() {
        return businessScope;
    }

    public void setBusinessScope(String businessScope) {
        this.businessScope = businessScope;
    }

    public CompanyModifyRequest withBusinessStartTime(String businessStartTime) {
        this.businessStartTime = businessStartTime;
        return this;
    }

    /**
    * 营业期限开始时间
    * @return businessStartTime
    **/
    @ApiModelProperty(value = "营业期限开始时间")


    public String getBusinessStartTime() {
        return businessStartTime;
    }

    public void setBusinessStartTime(String businessStartTime) {
        this.businessStartTime = businessStartTime;
    }

    public CompanyModifyRequest withBusinessTimeLong(String businessTimeLong) {
        this.businessTimeLong = businessTimeLong;
        return this;
    }

    /**
    * 营业期限时间是否长期 1：是 0：否
    * @return businessTimeLong
    **/
    @ApiModelProperty(value = "营业期限时间是否长期 1：是 0：否")


    public String getBusinessTimeLong() {
        return businessTimeLong;
    }

    public void setBusinessTimeLong(String businessTimeLong) {
        this.businessTimeLong = businessTimeLong;
    }

    public CompanyModifyRequest withCeQuota(String ceQuota) {
        this.ceQuota = ceQuota;
        return this;
    }

    /**
    * 增值税电子普通发票限额
    * @return ceQuota
    **/
    @ApiModelProperty(value = "增值税电子普通发票限额")


    public String getCeQuota() {
        return ceQuota;
    }

    public void setCeQuota(String ceQuota) {
        this.ceQuota = ceQuota;
    }

    public CompanyModifyRequest withCompanyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    /**
    * 主键ID
    * @return companyId
    **/
    @ApiModelProperty(value = "主键ID")


    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public CompanyModifyRequest withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    /**
    * 企业名称
    * @return companyName
    **/
    @ApiModelProperty(value = "企业名称")


    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public CompanyModifyRequest withCquota(String cquota) {
        this.cquota = cquota;
        return this;
    }

    /**
    * 增值税普通发票限额
    * @return cquota
    **/
    @ApiModelProperty(value = "增值税普通发票限额")


    public String getCquota() {
        return cquota;
    }

    public void setCquota(String cquota) {
        this.cquota = cquota;
    }

    public CompanyModifyRequest withCustomerType(String customerType) {
        this.customerType = customerType;
        return this;
    }

    /**
    * 客户类型 1：VIP客户 0：一般客户
    * @return customerType
    **/
    @ApiModelProperty(value = "客户类型 1：VIP客户 0：一般客户")


    public String getCustomerType() {
        return customerType;
    }

    public void setCustomerType(String customerType) {
        this.customerType = customerType;
    }

    public CompanyModifyRequest withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
    * 集团ID
    * @return groupId
    **/
    @ApiModelProperty(value = "集团ID")


    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public CompanyModifyRequest withJuQuota(String juQuota) {
        this.juQuota = juQuota;
        return this;
    }

    /**
    * 增值税普通发票(卷票）限额
    * @return juQuota
    **/
    @ApiModelProperty(value = "增值税普通发票(卷票）限额")


    public String getJuQuota() {
        return juQuota;
    }

    public void setJuQuota(String juQuota) {
        this.juQuota = juQuota;
    }

    public CompanyModifyRequest withLocationAddr(String locationAddr) {
        this.locationAddr = locationAddr;
        return this;
    }

    /**
    * 公司经营所在详细地址
    * @return locationAddr
    **/
    @ApiModelProperty(value = "公司经营所在详细地址")


    public String getLocationAddr() {
        return locationAddr;
    }

    public void setLocationAddr(String locationAddr) {
        this.locationAddr = locationAddr;
    }

    public CompanyModifyRequest withLocationArea(String locationArea) {
        this.locationArea = locationArea;
        return this;
    }

    /**
    * 公司经营所在省份
    * @return locationArea
    **/
    @ApiModelProperty(value = "公司经营所在省份")


    public String getLocationArea() {
        return locationArea;
    }

    public void setLocationArea(String locationArea) {
        this.locationArea = locationArea;
    }

    public CompanyModifyRequest withLocationCity(String locationCity) {
        this.locationCity = locationCity;
        return this;
    }

    /**
    * 公司经营所在市区
    * @return locationCity
    **/
    @ApiModelProperty(value = "公司经营所在市区")


    public String getLocationCity() {
        return locationCity;
    }

    public void setLocationCity(String locationCity) {
        this.locationCity = locationCity;
    }

    public CompanyModifyRequest withManagerIdCard(String managerIdCard) {
        this.managerIdCard = managerIdCard;
        return this;
    }

    /**
    * 法人身份证
    * @return managerIdCard
    **/
    @ApiModelProperty(value = "法人身份证")


    public String getManagerIdCard() {
        return managerIdCard;
    }

    public void setManagerIdCard(String managerIdCard) {
        this.managerIdCard = managerIdCard;
    }

    public CompanyModifyRequest withManagerIdCardBackPhoto(String managerIdCardBackPhoto) {
        this.managerIdCardBackPhoto = managerIdCardBackPhoto;
        return this;
    }

    /**
    * 法人证件背面照
    * @return managerIdCardBackPhoto
    **/
    @ApiModelProperty(value = "法人证件背面照")


    public String getManagerIdCardBackPhoto() {
        return managerIdCardBackPhoto;
    }

    public void setManagerIdCardBackPhoto(String managerIdCardBackPhoto) {
        this.managerIdCardBackPhoto = managerIdCardBackPhoto;
    }

    public CompanyModifyRequest withManagerIdCardEndTime(String managerIdCardEndTime) {
        this.managerIdCardEndTime = managerIdCardEndTime;
        return this;
    }

    /**
    * 法人证件结束时间
    * @return managerIdCardEndTime
    **/
    @ApiModelProperty(value = "法人证件结束时间")


    public String getManagerIdCardEndTime() {
        return managerIdCardEndTime;
    }

    public void setManagerIdCardEndTime(String managerIdCardEndTime) {
        this.managerIdCardEndTime = managerIdCardEndTime;
    }

    public CompanyModifyRequest withManagerIdCardFrontPhoto(String managerIdCardFrontPhoto) {
        this.managerIdCardFrontPhoto = managerIdCardFrontPhoto;
        return this;
    }

    /**
    * 法人证件正面照
    * @return managerIdCardFrontPhoto
    **/
    @ApiModelProperty(value = "法人证件正面照")


    public String getManagerIdCardFrontPhoto() {
        return managerIdCardFrontPhoto;
    }

    public void setManagerIdCardFrontPhoto(String managerIdCardFrontPhoto) {
        this.managerIdCardFrontPhoto = managerIdCardFrontPhoto;
    }

    public CompanyModifyRequest withManagerIdCardStartTime(String managerIdCardStartTime) {
        this.managerIdCardStartTime = managerIdCardStartTime;
        return this;
    }

    /**
    * 法人证件开始时间
    * @return managerIdCardStartTime
    **/
    @ApiModelProperty(value = "法人证件开始时间")


    public String getManagerIdCardStartTime() {
        return managerIdCardStartTime;
    }

    public void setManagerIdCardStartTime(String managerIdCardStartTime) {
        this.managerIdCardStartTime = managerIdCardStartTime;
    }

    public CompanyModifyRequest withManagerIdCardTimeLong(String managerIdCardTimeLong) {
        this.managerIdCardTimeLong = managerIdCardTimeLong;
        return this;
    }

    /**
    * 法人证件时间是否长期 1：是 0：否
    * @return managerIdCardTimeLong
    **/
    @ApiModelProperty(value = "法人证件时间是否长期 1：是 0：否")


    public String getManagerIdCardTimeLong() {
        return managerIdCardTimeLong;
    }

    public void setManagerIdCardTimeLong(String managerIdCardTimeLong) {
        this.managerIdCardTimeLong = managerIdCardTimeLong;
    }

    public CompanyModifyRequest withManagerLocation(String managerLocation) {
        this.managerLocation = managerLocation;
        return this;
    }

    /**
    * 法人归属地
    * @return managerLocation
    **/
    @ApiModelProperty(value = "法人归属地")


    public String getManagerLocation() {
        return managerLocation;
    }

    public void setManagerLocation(String managerLocation) {
        this.managerLocation = managerLocation;
    }

    public CompanyModifyRequest withManagerName(String managerName) {
        this.managerName = managerName;
        return this;
    }

    /**
    * 法人姓名
    * @return managerName
    **/
    @ApiModelProperty(value = "法人姓名")


    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    public CompanyModifyRequest withManagerPhone(String managerPhone) {
        this.managerPhone = managerPhone;
        return this;
    }

    /**
    * 法人联系方式
    * @return managerPhone
    **/
    @ApiModelProperty(value = "法人联系方式")


    public String getManagerPhone() {
        return managerPhone;
    }

    public void setManagerPhone(String managerPhone) {
        this.managerPhone = managerPhone;
    }

    public CompanyModifyRequest withPlatManagerStatus(String platManagerStatus) {
        this.platManagerStatus = platManagerStatus;
        return this;
    }

    /**
    * 平台管理人身份 0：法定代表人 1：代理人
    * @return platManagerStatus
    **/
    @ApiModelProperty(value = "平台管理人身份 0：法定代表人 1：代理人")


    public String getPlatManagerStatus() {
        return platManagerStatus;
    }

    public void setPlatManagerStatus(String platManagerStatus) {
        this.platManagerStatus = platManagerStatus;
    }

    public CompanyModifyRequest withProxyManagerIdCard(String proxyManagerIdCard) {
        this.proxyManagerIdCard = proxyManagerIdCard;
        return this;
    }

    /**
    * 代理人身份证
    * @return proxyManagerIdCard
    **/
    @ApiModelProperty(value = "代理人身份证")


    public String getProxyManagerIdCard() {
        return proxyManagerIdCard;
    }

    public void setProxyManagerIdCard(String proxyManagerIdCard) {
        this.proxyManagerIdCard = proxyManagerIdCard;
    }

    public CompanyModifyRequest withProxyManagerIdCardBackPhoto(String proxyManagerIdCardBackPhoto) {
        this.proxyManagerIdCardBackPhoto = proxyManagerIdCardBackPhoto;
        return this;
    }

    /**
    * 代理人证件背面照
    * @return proxyManagerIdCardBackPhoto
    **/
    @ApiModelProperty(value = "代理人证件背面照")


    public String getProxyManagerIdCardBackPhoto() {
        return proxyManagerIdCardBackPhoto;
    }

    public void setProxyManagerIdCardBackPhoto(String proxyManagerIdCardBackPhoto) {
        this.proxyManagerIdCardBackPhoto = proxyManagerIdCardBackPhoto;
    }

    public CompanyModifyRequest withProxyManagerIdCardEndTime(String proxyManagerIdCardEndTime) {
        this.proxyManagerIdCardEndTime = proxyManagerIdCardEndTime;
        return this;
    }

    /**
    * 代理人证件结束时间
    * @return proxyManagerIdCardEndTime
    **/
    @ApiModelProperty(value = "代理人证件结束时间")


    public String getProxyManagerIdCardEndTime() {
        return proxyManagerIdCardEndTime;
    }

    public void setProxyManagerIdCardEndTime(String proxyManagerIdCardEndTime) {
        this.proxyManagerIdCardEndTime = proxyManagerIdCardEndTime;
    }

    public CompanyModifyRequest withProxyManagerIdCardFrontPhoto(String proxyManagerIdCardFrontPhoto) {
        this.proxyManagerIdCardFrontPhoto = proxyManagerIdCardFrontPhoto;
        return this;
    }

    /**
    * 代理人证件正面照
    * @return proxyManagerIdCardFrontPhoto
    **/
    @ApiModelProperty(value = "代理人证件正面照")


    public String getProxyManagerIdCardFrontPhoto() {
        return proxyManagerIdCardFrontPhoto;
    }

    public void setProxyManagerIdCardFrontPhoto(String proxyManagerIdCardFrontPhoto) {
        this.proxyManagerIdCardFrontPhoto = proxyManagerIdCardFrontPhoto;
    }

    public CompanyModifyRequest withProxyManagerIdCardStartTime(String proxyManagerIdCardStartTime) {
        this.proxyManagerIdCardStartTime = proxyManagerIdCardStartTime;
        return this;
    }

    /**
    * 代理人证件开始时间
    * @return proxyManagerIdCardStartTime
    **/
    @ApiModelProperty(value = "代理人证件开始时间")


    public String getProxyManagerIdCardStartTime() {
        return proxyManagerIdCardStartTime;
    }

    public void setProxyManagerIdCardStartTime(String proxyManagerIdCardStartTime) {
        this.proxyManagerIdCardStartTime = proxyManagerIdCardStartTime;
    }

    public CompanyModifyRequest withProxyManagerIdCardTimeLong(String proxyManagerIdCardTimeLong) {
        this.proxyManagerIdCardTimeLong = proxyManagerIdCardTimeLong;
        return this;
    }

    /**
    * 代理人证件时间是否长期 1：是 0：否
    * @return proxyManagerIdCardTimeLong
    **/
    @ApiModelProperty(value = "代理人证件时间是否长期 1：是 0：否")


    public String getProxyManagerIdCardTimeLong() {
        return proxyManagerIdCardTimeLong;
    }

    public void setProxyManagerIdCardTimeLong(String proxyManagerIdCardTimeLong) {
        this.proxyManagerIdCardTimeLong = proxyManagerIdCardTimeLong;
    }

    public CompanyModifyRequest withProxyManagerName(String proxyManagerName) {
        this.proxyManagerName = proxyManagerName;
        return this;
    }

    /**
    * 代理人姓名
    * @return proxyManagerName
    **/
    @ApiModelProperty(value = "代理人姓名")


    public String getProxyManagerName() {
        return proxyManagerName;
    }

    public void setProxyManagerName(String proxyManagerName) {
        this.proxyManagerName = proxyManagerName;
    }

    public CompanyModifyRequest withProxyManagerPhone(String proxyManagerPhone) {
        this.proxyManagerPhone = proxyManagerPhone;
        return this;
    }

    /**
    * 代理人联系方式
    * @return proxyManagerPhone
    **/
    @ApiModelProperty(value = "代理人联系方式")


    public String getProxyManagerPhone() {
        return proxyManagerPhone;
    }

    public void setProxyManagerPhone(String proxyManagerPhone) {
        this.proxyManagerPhone = proxyManagerPhone;
    }

    public CompanyModifyRequest withRegistLocationAddr(String registLocationAddr) {
        this.registLocationAddr = registLocationAddr;
        return this;
    }

    /**
    * 公司注册所在详细地址
    * @return registLocationAddr
    **/
    @ApiModelProperty(value = "公司注册所在详细地址")


    public String getRegistLocationAddr() {
        return registLocationAddr;
    }

    public void setRegistLocationAddr(String registLocationAddr) {
        this.registLocationAddr = registLocationAddr;
    }

    public CompanyModifyRequest withRegistLocationArea(String registLocationArea) {
        this.registLocationArea = registLocationArea;
        return this;
    }

    /**
    * 公司注册所在省份
    * @return registLocationArea
    **/
    @ApiModelProperty(value = "公司注册所在省份")


    public String getRegistLocationArea() {
        return registLocationArea;
    }

    public void setRegistLocationArea(String registLocationArea) {
        this.registLocationArea = registLocationArea;
    }

    public CompanyModifyRequest withRegistLocationCity(String registLocationCity) {
        this.registLocationCity = registLocationCity;
        return this;
    }

    /**
    * 公司注册所在市区
    * @return registLocationCity
    **/
    @ApiModelProperty(value = "公司注册所在市区")


    public String getRegistLocationCity() {
        return registLocationCity;
    }

    public void setRegistLocationCity(String registLocationCity) {
        this.registLocationCity = registLocationCity;
    }

    public CompanyModifyRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public CompanyModifyRequest withSquota(String squota) {
        this.squota = squota;
        return this;
    }

    /**
    * 增值税专用发票限额
    * @return squota
    **/
    @ApiModelProperty(value = "增值税专用发票限额")


    public String getSquota() {
        return squota;
    }

    public void setSquota(String squota) {
        this.squota = squota;
    }

    public CompanyModifyRequest withTaxpayerQualification(String taxpayerQualification) {
        this.taxpayerQualification = taxpayerQualification;
        return this;
    }

    /**
    * 纳税人资质证书
    * @return taxpayerQualification
    **/
    @ApiModelProperty(value = "纳税人资质证书")


    public String getTaxpayerQualification() {
        return taxpayerQualification;
    }

    public void setTaxpayerQualification(String taxpayerQualification) {
        this.taxpayerQualification = taxpayerQualification;
    }

    public CompanyModifyRequest withTaxpayerQualificationType(String taxpayerQualificationType) {
        this.taxpayerQualificationType = taxpayerQualificationType;
        return this;
    }

    /**
    * 纳税人资质类型 1:一般增值税纳税人 2:小规模纳税人
    * @return taxpayerQualificationType
    **/
    @ApiModelProperty(value = "纳税人资质类型 1:一般增值税纳税人 2:小规模纳税人")


    public String getTaxpayerQualificationType() {
        return taxpayerQualificationType;
    }

    public void setTaxpayerQualificationType(String taxpayerQualificationType) {
        this.taxpayerQualificationType = taxpayerQualificationType;
    }

    public CompanyModifyRequest withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
    * 管理员账号
    * @return tenantId
    **/
    @ApiModelProperty(value = "管理员账号")


    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CompanyModifyRequest companyModifyRequest = (CompanyModifyRequest) o;
        return Objects.equals(this.bankAddr, companyModifyRequest.bankAddr) &&
            Objects.equals(this.bankArea, companyModifyRequest.bankArea) &&
            Objects.equals(this.bankBranchName, companyModifyRequest.bankBranchName) &&
            Objects.equals(this.bankCity, companyModifyRequest.bankCity) &&
            Objects.equals(this.bankName, companyModifyRequest.bankName) &&
            Objects.equals(this.bankNo, companyModifyRequest.bankNo) &&
            Objects.equals(this.businessEndTime, companyModifyRequest.businessEndTime) &&
            Objects.equals(this.businessLicense, companyModifyRequest.businessLicense) &&
            Objects.equals(this.businessScope, companyModifyRequest.businessScope) &&
            Objects.equals(this.businessStartTime, companyModifyRequest.businessStartTime) &&
            Objects.equals(this.businessTimeLong, companyModifyRequest.businessTimeLong) &&
            Objects.equals(this.ceQuota, companyModifyRequest.ceQuota) &&
            Objects.equals(this.companyId, companyModifyRequest.companyId) &&
            Objects.equals(this.companyName, companyModifyRequest.companyName) &&
            Objects.equals(this.cquota, companyModifyRequest.cquota) &&
            Objects.equals(this.customerType, companyModifyRequest.customerType) &&
            Objects.equals(this.groupId, companyModifyRequest.groupId) &&
            Objects.equals(this.juQuota, companyModifyRequest.juQuota) &&
            Objects.equals(this.locationAddr, companyModifyRequest.locationAddr) &&
            Objects.equals(this.locationArea, companyModifyRequest.locationArea) &&
            Objects.equals(this.locationCity, companyModifyRequest.locationCity) &&
            Objects.equals(this.managerIdCard, companyModifyRequest.managerIdCard) &&
            Objects.equals(this.managerIdCardBackPhoto, companyModifyRequest.managerIdCardBackPhoto) &&
            Objects.equals(this.managerIdCardEndTime, companyModifyRequest.managerIdCardEndTime) &&
            Objects.equals(this.managerIdCardFrontPhoto, companyModifyRequest.managerIdCardFrontPhoto) &&
            Objects.equals(this.managerIdCardStartTime, companyModifyRequest.managerIdCardStartTime) &&
            Objects.equals(this.managerIdCardTimeLong, companyModifyRequest.managerIdCardTimeLong) &&
            Objects.equals(this.managerLocation, companyModifyRequest.managerLocation) &&
            Objects.equals(this.managerName, companyModifyRequest.managerName) &&
            Objects.equals(this.managerPhone, companyModifyRequest.managerPhone) &&
            Objects.equals(this.platManagerStatus, companyModifyRequest.platManagerStatus) &&
            Objects.equals(this.proxyManagerIdCard, companyModifyRequest.proxyManagerIdCard) &&
            Objects.equals(this.proxyManagerIdCardBackPhoto, companyModifyRequest.proxyManagerIdCardBackPhoto) &&
            Objects.equals(this.proxyManagerIdCardEndTime, companyModifyRequest.proxyManagerIdCardEndTime) &&
            Objects.equals(this.proxyManagerIdCardFrontPhoto, companyModifyRequest.proxyManagerIdCardFrontPhoto) &&
            Objects.equals(this.proxyManagerIdCardStartTime, companyModifyRequest.proxyManagerIdCardStartTime) &&
            Objects.equals(this.proxyManagerIdCardTimeLong, companyModifyRequest.proxyManagerIdCardTimeLong) &&
            Objects.equals(this.proxyManagerName, companyModifyRequest.proxyManagerName) &&
            Objects.equals(this.proxyManagerPhone, companyModifyRequest.proxyManagerPhone) &&
            Objects.equals(this.registLocationAddr, companyModifyRequest.registLocationAddr) &&
            Objects.equals(this.registLocationArea, companyModifyRequest.registLocationArea) &&
            Objects.equals(this.registLocationCity, companyModifyRequest.registLocationCity) &&
            Objects.equals(this.rid, companyModifyRequest.rid) &&
            Objects.equals(this.squota, companyModifyRequest.squota) &&
            Objects.equals(this.taxpayerQualification, companyModifyRequest.taxpayerQualification) &&
            Objects.equals(this.taxpayerQualificationType, companyModifyRequest.taxpayerQualificationType) &&
            Objects.equals(this.tenantId, companyModifyRequest.tenantId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(bankAddr, bankArea, bankBranchName, bankCity, bankName, bankNo, businessEndTime, businessLicense, businessScope, businessStartTime, businessTimeLong, ceQuota, companyId, companyName, cquota, customerType, groupId, juQuota, locationAddr, locationArea, locationCity, managerIdCard, managerIdCardBackPhoto, managerIdCardEndTime, managerIdCardFrontPhoto, managerIdCardStartTime, managerIdCardTimeLong, managerLocation, managerName, managerPhone, platManagerStatus, proxyManagerIdCard, proxyManagerIdCardBackPhoto, proxyManagerIdCardEndTime, proxyManagerIdCardFrontPhoto, proxyManagerIdCardStartTime, proxyManagerIdCardTimeLong, proxyManagerName, proxyManagerPhone, registLocationAddr, registLocationArea, registLocationCity, rid, squota, taxpayerQualification, taxpayerQualificationType, tenantId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link CompanyModifyRequest }.
     */
    public static CompanyModifyRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, CompanyModifyRequest.class);
    }
}

