package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 企业Request
 */
@ApiModel(description = "企业Request")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class CompanySelectRequest   {
    @JsonProperty("groupId")
    private String groupId = null;

    @JsonProperty("returnGroupListFlag")
    private Boolean returnGroupListFlag = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("value")
    private String value = null;

    public CompanySelectRequest withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
    * 集团id
    * @return groupId
    **/
    @ApiModelProperty(value = "集团id")


    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public CompanySelectRequest withReturnGroupListFlag(Boolean returnGroupListFlag) {
        this.returnGroupListFlag = returnGroupListFlag;
        return this;
    }

    /**
    * 是否返回集团列表信息 默认false
    * @return returnGroupListFlag
    **/
    @ApiModelProperty(example = "false", value = "是否返回集团列表信息 默认false")


    public Boolean isgetReturnGroupListFlag() {
        return returnGroupListFlag;
    }

    public void setReturnGroupListFlag(Boolean returnGroupListFlag) {
        this.returnGroupListFlag = returnGroupListFlag;
    }

    public CompanySelectRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public CompanySelectRequest withValue(String value) {
        this.value = value;
        return this;
    }

    /**
    * 支持 公司名称，税号 模糊查询
    * @return value
    **/
    @ApiModelProperty(value = "支持 公司名称，税号 模糊查询")


    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CompanySelectRequest companySelectRequest = (CompanySelectRequest) o;
        return Objects.equals(this.groupId, companySelectRequest.groupId) &&
            Objects.equals(this.returnGroupListFlag, companySelectRequest.returnGroupListFlag) &&
            Objects.equals(this.rid, companySelectRequest.rid) &&
            Objects.equals(this.value, companySelectRequest.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(groupId, returnGroupListFlag, rid, value);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link CompanySelectRequest }.
     */
    public static CompanySelectRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, CompanySelectRequest.class);
    }
}

