package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 公司服务包Model
 */
@ApiModel(description = "公司服务包Model")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class ContractServiceAddRequest   {
    @JsonProperty("companyId")
    private String companyId = null;

    @JsonProperty("companyName")
    private String companyName = null;

    @JsonProperty("remark")
    private String remark = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("servicePackageIds")
    @Valid
    private List<String> servicePackageIds = null;

    public ContractServiceAddRequest withCompanyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    /**
    * 公司主键
    * @return companyId
    **/
    @ApiModelProperty(value = "公司主键")


    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public ContractServiceAddRequest withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    /**
    * 公司名称
    * @return companyName
    **/
    @ApiModelProperty(value = "公司名称")


    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public ContractServiceAddRequest withRemark(String remark) {
        this.remark = remark;
        return this;
    }

    /**
    * 合同备注
    * @return remark
    **/
    @ApiModelProperty(value = "合同备注")


    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public ContractServiceAddRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * rid
    * @return rid
    **/
    @ApiModelProperty(value = "rid")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public ContractServiceAddRequest withServicePackageIds(List<String> servicePackageIds) {
        this.servicePackageIds = servicePackageIds;
        return this;
    }

    public ContractServiceAddRequest withServicePackageIdsAdd(String servicePackageIds) {
        if (this.servicePackageIds == null) {
            this.servicePackageIds = new ArrayList<String>();
        }
        this.servicePackageIds.add(servicePackageIds);
        return this;
    }

    /**
    * 服务包主键列表
    * @return servicePackageIds
    **/
    @ApiModelProperty(value = "服务包主键列表")


    public List<String> getServicePackageIds() {
        return servicePackageIds;
    }

    public void setServicePackageIds(List<String> servicePackageIds) {
        this.servicePackageIds = servicePackageIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ContractServiceAddRequest contractServiceAddRequest = (ContractServiceAddRequest) o;
        return Objects.equals(this.companyId, contractServiceAddRequest.companyId) &&
            Objects.equals(this.companyName, contractServiceAddRequest.companyName) &&
            Objects.equals(this.remark, contractServiceAddRequest.remark) &&
            Objects.equals(this.rid, contractServiceAddRequest.rid) &&
            Objects.equals(this.servicePackageIds, contractServiceAddRequest.servicePackageIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyId, companyName, remark, rid, servicePackageIds);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link ContractServiceAddRequest }.
     */
    public static ContractServiceAddRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, ContractServiceAddRequest.class);
    }
}

