package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 公司服务包Model
 */
@ApiModel(description = "公司服务包Model")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class ContractServiceChangeStatusRequest   {
    @JsonProperty("contractId")
    private String contractId = null;

    @JsonProperty("id")
    private String id = null;

    @JsonProperty("remarks")
    private String remarks = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("status")
    private String status = null;

    public ContractServiceChangeStatusRequest withContractId(String contractId) {
        this.contractId = contractId;
        return this;
    }

    /**
    * 合同主键
    * @return contractId
    **/
    @ApiModelProperty(value = "合同主键")


    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public ContractServiceChangeStatusRequest withId(String id) {
        this.id = id;
        return this;
    }

    /**
    * 主键
    * @return id
    **/
    @ApiModelProperty(value = "主键")


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ContractServiceChangeStatusRequest withRemarks(String remarks) {
        this.remarks = remarks;
        return this;
    }

    /**
    * 备注原因
    * @return remarks
    **/
    @ApiModelProperty(value = "备注原因")


    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public ContractServiceChangeStatusRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * rid
    * @return rid
    **/
    @ApiModelProperty(value = "rid")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public ContractServiceChangeStatusRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 状态： 1：启用 0：注销
    * @return status
    **/
    @ApiModelProperty(value = "状态： 1：启用 0：注销")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ContractServiceChangeStatusRequest contractServiceChangeStatusRequest = (ContractServiceChangeStatusRequest) o;
        return Objects.equals(this.contractId, contractServiceChangeStatusRequest.contractId) &&
            Objects.equals(this.id, contractServiceChangeStatusRequest.id) &&
            Objects.equals(this.remarks, contractServiceChangeStatusRequest.remarks) &&
            Objects.equals(this.rid, contractServiceChangeStatusRequest.rid) &&
            Objects.equals(this.status, contractServiceChangeStatusRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(contractId, id, remarks, rid, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link ContractServiceChangeStatusRequest }.
     */
    public static ContractServiceChangeStatusRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, ContractServiceChangeStatusRequest.class);
    }
}

