package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.yiwan.seiya.phoenix.bss.app.model.ServicePackageModelDetail;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 公司服务包Model
 */
@ApiModel(description = "公司服务包Model")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class ContractServiceModelDetail   {
    @JsonProperty("companyName")
    private String companyName = null;

    @JsonProperty("createTime")
    private String createTime = null;

    @JsonProperty("createUserId")
    private String createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonProperty("id")
    private String id = null;

    @JsonProperty("remark")
    private String remark = null;

    @JsonProperty("resourcesetNames")
    private String resourcesetNames = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("servicePackageDtoList")
    @Valid
    private List<ServicePackageModelDetail> servicePackageDtoList = null;

    @JsonProperty("servicePackageName")
    private String servicePackageName = null;

    @JsonProperty("status")
    private String status = null;

    public ContractServiceModelDetail withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    /**
    * 公司名称
    * @return companyName
    **/
    @ApiModelProperty(value = "公司名称")


    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public ContractServiceModelDetail withCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
    * 创建时间
    * @return createTime
    **/
    @ApiModelProperty(value = "创建时间")


    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public ContractServiceModelDetail withCreateUserId(String createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    /**
    * 创建人ID
    * @return createUserId
    **/
    @ApiModelProperty(value = "创建人ID")


    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public ContractServiceModelDetail withCreateUserName(String createUserName) {
        this.createUserName = createUserName;
        return this;
    }

    /**
    * 创建人名称
    * @return createUserName
    **/
    @ApiModelProperty(value = "创建人名称")


    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public ContractServiceModelDetail withId(String id) {
        this.id = id;
        return this;
    }

    /**
    * 主键
    * @return id
    **/
    @ApiModelProperty(value = "主键")


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ContractServiceModelDetail withRemark(String remark) {
        this.remark = remark;
        return this;
    }

    /**
    * 合同备注
    * @return remark
    **/
    @ApiModelProperty(value = "合同备注")


    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public ContractServiceModelDetail withResourcesetNames(String resourcesetNames) {
        this.resourcesetNames = resourcesetNames;
        return this;
    }

    /**
    * 功能集名称集合
    * @return resourcesetNames
    **/
    @ApiModelProperty(value = "功能集名称集合")


    public String getResourcesetNames() {
        return resourcesetNames;
    }

    public void setResourcesetNames(String resourcesetNames) {
        this.resourcesetNames = resourcesetNames;
    }

    public ContractServiceModelDetail withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * rid
    * @return rid
    **/
    @ApiModelProperty(value = "rid")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public ContractServiceModelDetail withServicePackageDtoList(List<ServicePackageModelDetail> servicePackageDtoList) {
        this.servicePackageDtoList = servicePackageDtoList;
        return this;
    }

    public ContractServiceModelDetail withServicePackageDtoListAdd(ServicePackageModelDetail servicePackageDtoList) {
        if (this.servicePackageDtoList == null) {
            this.servicePackageDtoList = new ArrayList<ServicePackageModelDetail>();
        }
        this.servicePackageDtoList.add(servicePackageDtoList);
        return this;
    }

    /**
    * 服务包列表
    * @return servicePackageDtoList
    **/
    @ApiModelProperty(value = "服务包列表")

  @Valid

    public List<ServicePackageModelDetail> getServicePackageDtoList() {
        return servicePackageDtoList;
    }

    public void setServicePackageDtoList(List<ServicePackageModelDetail> servicePackageDtoList) {
        this.servicePackageDtoList = servicePackageDtoList;
    }

    public ContractServiceModelDetail withServicePackageName(String servicePackageName) {
        this.servicePackageName = servicePackageName;
        return this;
    }

    /**
    * 公司名称
    * @return servicePackageName
    **/
    @ApiModelProperty(value = "公司名称")


    public String getServicePackageName() {
        return servicePackageName;
    }

    public void setServicePackageName(String servicePackageName) {
        this.servicePackageName = servicePackageName;
    }

    public ContractServiceModelDetail withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 状态： 1：启用 0：注销
    * @return status
    **/
    @ApiModelProperty(value = "状态： 1：启用 0：注销")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ContractServiceModelDetail contractServiceModelDetail = (ContractServiceModelDetail) o;
        return Objects.equals(this.companyName, contractServiceModelDetail.companyName) &&
            Objects.equals(this.createTime, contractServiceModelDetail.createTime) &&
            Objects.equals(this.createUserId, contractServiceModelDetail.createUserId) &&
            Objects.equals(this.createUserName, contractServiceModelDetail.createUserName) &&
            Objects.equals(this.id, contractServiceModelDetail.id) &&
            Objects.equals(this.remark, contractServiceModelDetail.remark) &&
            Objects.equals(this.resourcesetNames, contractServiceModelDetail.resourcesetNames) &&
            Objects.equals(this.rid, contractServiceModelDetail.rid) &&
            Objects.equals(this.servicePackageDtoList, contractServiceModelDetail.servicePackageDtoList) &&
            Objects.equals(this.servicePackageName, contractServiceModelDetail.servicePackageName) &&
            Objects.equals(this.status, contractServiceModelDetail.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyName, createTime, createUserId, createUserName, id, remark, resourcesetNames, rid, servicePackageDtoList, servicePackageName, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link ContractServiceModelDetail }.
     */
    public static ContractServiceModelDetail fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, ContractServiceModelDetail.class);
    }
}

