package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 企业新增请求对象
 */
@ApiModel(description = "企业新增请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class DeviceAddRequest   {
    @JsonProperty("confirmInvoiceTimeout")
    private String confirmInvoiceTimeout = null;

    @JsonProperty("deployType")
    private String deployType = null;

    @JsonProperty("deviceNo")
    private String deviceNo = null;

    @JsonProperty("invoiceType")
    @Valid
    private List<String> invoiceType = null;

    @JsonProperty("ip")
    private String ip = null;

    @JsonProperty("nationalTaxPassword")
    private String nationalTaxPassword = null;

    @JsonProperty("photos")
    @Valid
    private List<String> photos = null;

    @JsonProperty("port")
    private String port = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("serverUrl")
    private String serverUrl = null;

    @JsonProperty("service")
    @Valid
    private List<String> service = null;

    @JsonProperty("showMachineNoInRemarkFlag")
    private String showMachineNoInRemarkFlag = null;

    @JsonProperty("taxControlKey")
    private String taxControlKey = null;

    @JsonProperty("taxDeviceDigitalPassword")
    private String taxDeviceDigitalPassword = null;

    @JsonProperty("taxDeviceMachineNo")
    private String taxDeviceMachineNo = null;

    @JsonProperty("taxDevicePassword")
    private String taxDevicePassword = null;

    @JsonProperty("taxDeviceType")
    private String taxDeviceType = null;

    @JsonProperty("taxNum")
    private String taxNum = null;

    public DeviceAddRequest withConfirmInvoiceTimeout(String confirmInvoiceTimeout) {
        this.confirmInvoiceTimeout = confirmInvoiceTimeout;
        return this;
    }

    /**
    * 响应时长，确认发票号超时时间,单位毫秒,默认：300000
    * @return confirmInvoiceTimeout
    **/
    @ApiModelProperty(value = "响应时长，确认发票号超时时间,单位毫秒,默认：300000")


    public String getConfirmInvoiceTimeout() {
        return confirmInvoiceTimeout;
    }

    public void setConfirmInvoiceTimeout(String confirmInvoiceTimeout) {
        this.confirmInvoiceTimeout = confirmInvoiceTimeout;
    }

    public DeviceAddRequest withDeployType(String deployType) {
        this.deployType = deployType;
        return this;
    }

    /**
    * 部署类型，1:票易通自建 2：托管 3：陈列
    * @return deployType
    **/
    @ApiModelProperty(value = "部署类型，1:票易通自建 2：托管 3：陈列")


    public String getDeployType() {
        return deployType;
    }

    public void setDeployType(String deployType) {
        this.deployType = deployType;
    }

    public DeviceAddRequest withDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
        return this;
    }

    /**
    * 设备编号
    * @return deviceNo
    **/
    @ApiModelProperty(value = "设备编号")


    public String getDeviceNo() {
        return deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public DeviceAddRequest withInvoiceType(List<String> invoiceType) {
        this.invoiceType = invoiceType;
        return this;
    }

    public DeviceAddRequest withInvoiceTypeAdd(String invoiceType) {
        if (this.invoiceType == null) {
            this.invoiceType = new ArrayList<String>();
        }
        this.invoiceType.add(invoiceType);
        return this;
    }

    /**
    * 发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）
    * @return invoiceType
    **/
    @ApiModelProperty(value = "发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）")


    public List<String> getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(List<String> invoiceType) {
        this.invoiceType = invoiceType;
    }

    public DeviceAddRequest withIp(String ip) {
        this.ip = ip;
        return this;
    }

    /**
    * ip:服务器模式时输入
    * @return ip
    **/
    @ApiModelProperty(value = "ip:服务器模式时输入")


    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public DeviceAddRequest withNationalTaxPassword(String nationalTaxPassword) {
        this.nationalTaxPassword = nationalTaxPassword;
        return this;
    }

    /**
    * 国税自定义密码
    * @return nationalTaxPassword
    **/
    @ApiModelProperty(value = "国税自定义密码")


    public String getNationalTaxPassword() {
        return nationalTaxPassword;
    }

    public void setNationalTaxPassword(String nationalTaxPassword) {
        this.nationalTaxPassword = nationalTaxPassword;
    }

    public DeviceAddRequest withPhotos(List<String> photos) {
        this.photos = photos;
        return this;
    }

    public DeviceAddRequest withPhotosAdd(String photos) {
        if (this.photos == null) {
            this.photos = new ArrayList<String>();
        }
        this.photos.add(photos);
        return this;
    }

    /**
    * 图片
    * @return photos
    **/
    @ApiModelProperty(value = "图片")


    public List<String> getPhotos() {
        return photos;
    }

    public void setPhotos(List<String> photos) {
        this.photos = photos;
    }

    public DeviceAddRequest withPort(String port) {
        this.port = port;
        return this;
    }

    /**
    * 端口：服务器模式时输入
    * @return port
    **/
    @ApiModelProperty(value = "端口：服务器模式时输入")


    public String getPort() {
        return port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public DeviceAddRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public DeviceAddRequest withServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    /**
    * 直连服务器版涉及到的URL信息 示例：TaxPBserver/kpservices/KpWebService
    * @return serverUrl
    **/
    @ApiModelProperty(value = "直连服务器版涉及到的URL信息 示例：TaxPBserver/kpservices/KpWebService")


    public String getServerUrl() {
        return serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public DeviceAddRequest withService(List<String> service) {
        this.service = service;
        return this;
    }

    public DeviceAddRequest withServiceAdd(String service) {
        if (this.service == null) {
            this.service = new ArrayList<String>();
        }
        this.service.add(service);
        return this;
    }

    /**
    * 支持的服务 （make：开票 ，print：打印，originAccount：底账,assistant：辅助）
    * @return service
    **/
    @ApiModelProperty(value = "支持的服务 （make：开票 ，print：打印，originAccount：底账,assistant：辅助）")


    public List<String> getService() {
        return service;
    }

    public void setService(List<String> service) {
        this.service = service;
    }

    public DeviceAddRequest withShowMachineNoInRemarkFlag(String showMachineNoInRemarkFlag) {
        this.showMachineNoInRemarkFlag = showMachineNoInRemarkFlag;
        return this;
    }

    /**
    * 添加开票机号显示标志：0-在备注里加开票机号  1-不在备注里加开票机号
    * @return showMachineNoInRemarkFlag
    **/
    @ApiModelProperty(value = "添加开票机号显示标志：0-在备注里加开票机号  1-不在备注里加开票机号")


    public String getShowMachineNoInRemarkFlag() {
        return showMachineNoInRemarkFlag;
    }

    public void setShowMachineNoInRemarkFlag(String showMachineNoInRemarkFlag) {
        this.showMachineNoInRemarkFlag = showMachineNoInRemarkFlag;
    }

    public DeviceAddRequest withTaxControlKey(String taxControlKey) {
        this.taxControlKey = taxControlKey;
        return this;
    }

    /**
    * 税控钥匙密码
    * @return taxControlKey
    **/
    @ApiModelProperty(value = "税控钥匙密码")


    public String getTaxControlKey() {
        return taxControlKey;
    }

    public void setTaxControlKey(String taxControlKey) {
        this.taxControlKey = taxControlKey;
    }

    public DeviceAddRequest withTaxDeviceDigitalPassword(String taxDeviceDigitalPassword) {
        this.taxDeviceDigitalPassword = taxDeviceDigitalPassword;
        return this;
    }

    /**
    * 税务数字证书密码
    * @return taxDeviceDigitalPassword
    **/
    @ApiModelProperty(value = "税务数字证书密码")


    public String getTaxDeviceDigitalPassword() {
        return taxDeviceDigitalPassword;
    }

    public void setTaxDeviceDigitalPassword(String taxDeviceDigitalPassword) {
        this.taxDeviceDigitalPassword = taxDeviceDigitalPassword;
    }

    public DeviceAddRequest withTaxDeviceMachineNo(String taxDeviceMachineNo) {
        this.taxDeviceMachineNo = taxDeviceMachineNo;
        return this;
    }

    /**
    * 开票机号
    * @return taxDeviceMachineNo
    **/
    @ApiModelProperty(value = "开票机号")


    public String getTaxDeviceMachineNo() {
        return taxDeviceMachineNo;
    }

    public void setTaxDeviceMachineNo(String taxDeviceMachineNo) {
        this.taxDeviceMachineNo = taxDeviceMachineNo;
    }

    public DeviceAddRequest withTaxDevicePassword(String taxDevicePassword) {
        this.taxDevicePassword = taxDevicePassword;
        return this;
    }

    /**
    * 税控盘密码
    * @return taxDevicePassword
    **/
    @ApiModelProperty(value = "税控盘密码")


    public String getTaxDevicePassword() {
        return taxDevicePassword;
    }

    public void setTaxDevicePassword(String taxDevicePassword) {
        this.taxDevicePassword = taxDevicePassword;
    }

    public DeviceAddRequest withTaxDeviceType(String taxDeviceType) {
        this.taxDeviceType = taxDeviceType;
        return this;
    }

    /**
    * 设备类型，1 百望单盘 2 百望服务器  3 航信单盘 4 航信服务器
    * @return taxDeviceType
    **/
    @ApiModelProperty(value = "设备类型，1 百望单盘 2 百望服务器  3 航信单盘 4 航信服务器")


    public String getTaxDeviceType() {
        return taxDeviceType;
    }

    public void setTaxDeviceType(String taxDeviceType) {
        this.taxDeviceType = taxDeviceType;
    }

    public DeviceAddRequest withTaxNum(String taxNum) {
        this.taxNum = taxNum;
        return this;
    }

    /**
    * 企业纳税人识别号
    * @return taxNum
    **/
    @ApiModelProperty(value = "企业纳税人识别号")


    public String getTaxNum() {
        return taxNum;
    }

    public void setTaxNum(String taxNum) {
        this.taxNum = taxNum;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeviceAddRequest deviceAddRequest = (DeviceAddRequest) o;
        return Objects.equals(this.confirmInvoiceTimeout, deviceAddRequest.confirmInvoiceTimeout) &&
            Objects.equals(this.deployType, deviceAddRequest.deployType) &&
            Objects.equals(this.deviceNo, deviceAddRequest.deviceNo) &&
            Objects.equals(this.invoiceType, deviceAddRequest.invoiceType) &&
            Objects.equals(this.ip, deviceAddRequest.ip) &&
            Objects.equals(this.nationalTaxPassword, deviceAddRequest.nationalTaxPassword) &&
            Objects.equals(this.photos, deviceAddRequest.photos) &&
            Objects.equals(this.port, deviceAddRequest.port) &&
            Objects.equals(this.rid, deviceAddRequest.rid) &&
            Objects.equals(this.serverUrl, deviceAddRequest.serverUrl) &&
            Objects.equals(this.service, deviceAddRequest.service) &&
            Objects.equals(this.showMachineNoInRemarkFlag, deviceAddRequest.showMachineNoInRemarkFlag) &&
            Objects.equals(this.taxControlKey, deviceAddRequest.taxControlKey) &&
            Objects.equals(this.taxDeviceDigitalPassword, deviceAddRequest.taxDeviceDigitalPassword) &&
            Objects.equals(this.taxDeviceMachineNo, deviceAddRequest.taxDeviceMachineNo) &&
            Objects.equals(this.taxDevicePassword, deviceAddRequest.taxDevicePassword) &&
            Objects.equals(this.taxDeviceType, deviceAddRequest.taxDeviceType) &&
            Objects.equals(this.taxNum, deviceAddRequest.taxNum);
    }

    @Override
    public int hashCode() {
        return Objects.hash(confirmInvoiceTimeout, deployType, deviceNo, invoiceType, ip, nationalTaxPassword, photos, port, rid, serverUrl, service, showMachineNoInRemarkFlag, taxControlKey, taxDeviceDigitalPassword, taxDeviceMachineNo, taxDevicePassword, taxDeviceType, taxNum);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link DeviceAddRequest }.
     */
    public static DeviceAddRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, DeviceAddRequest.class);
    }
}

