package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * null
 */
@ApiModel(description = "null")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class DeviceApplyModel   {
    @JsonProperty("companyName")
    private String companyName = null;

    @JsonProperty("confirmInvoiceTimeout")
    private Integer confirmInvoiceTimeout = null;

    @JsonProperty("createTime")
    private String createTime = null;

    @JsonProperty("deployType")
    private Integer deployType = null;

    @JsonProperty("deviceNo")
    private String deviceNo = null;

    @JsonProperty("deviceType")
    private String deviceType = null;

    @JsonProperty("id")
    private Long id = null;

    @JsonProperty("invoiceType")
    @Valid
    private List<String> invoiceType = null;

    @JsonProperty("ip")
    private String ip = null;

    @JsonProperty("nationalTaxPassword")
    private String nationalTaxPassword = null;

    @JsonProperty("photos")
    @Valid
    private List<String> photos = null;

    @JsonProperty("port")
    private Integer port = null;

    @JsonProperty("serverUrl")
    private String serverUrl = null;

    @JsonProperty("service")
    @Valid
    private List<String> service = null;

    @JsonProperty("showMachineNoInRemarkFlag")
    private String showMachineNoInRemarkFlag = null;

    @JsonProperty("status")
    private Integer status = null;

    @JsonProperty("taxControlKey")
    private String taxControlKey = null;

    @JsonProperty("taxDeviceDigitalPassword")
    private String taxDeviceDigitalPassword = null;

    @JsonProperty("taxDeviceMachineNo")
    private String taxDeviceMachineNo = null;

    @JsonProperty("taxDevicePassword")
    private String taxDevicePassword = null;

    @JsonProperty("taxDeviceType")
    private Integer taxDeviceType = null;

    @JsonProperty("taxNum")
    private String taxNum = null;

    public DeviceApplyModel withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    /**
    * 公司名称
    * @return companyName
    **/
    @ApiModelProperty(value = "公司名称")


    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public DeviceApplyModel withConfirmInvoiceTimeout(Integer confirmInvoiceTimeout) {
        this.confirmInvoiceTimeout = confirmInvoiceTimeout;
        return this;
    }

    /**
    * 响应时长，确认发票号超时时间,单位毫秒,默认：300000
    * @return confirmInvoiceTimeout
    **/
    @ApiModelProperty(value = "响应时长，确认发票号超时时间,单位毫秒,默认：300000")


    public Integer getConfirmInvoiceTimeout() {
        return confirmInvoiceTimeout;
    }

    public void setConfirmInvoiceTimeout(Integer confirmInvoiceTimeout) {
        this.confirmInvoiceTimeout = confirmInvoiceTimeout;
    }

    public DeviceApplyModel withCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
    * 创建时间
    * @return createTime
    **/
    @ApiModelProperty(value = "创建时间")


    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public DeviceApplyModel withDeployType(Integer deployType) {
        this.deployType = deployType;
        return this;
    }

    /**
    * 部署类型，1:票易通自建 2：托管 3：陈列
    * @return deployType
    **/
    @ApiModelProperty(value = "部署类型，1:票易通自建 2：托管 3：陈列")


    public Integer getDeployType() {
        return deployType;
    }

    public void setDeployType(Integer deployType) {
        this.deployType = deployType;
    }

    public DeviceApplyModel withDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
        return this;
    }

    /**
    * 设备编号
    * @return deviceNo
    **/
    @ApiModelProperty(value = "设备编号")


    public String getDeviceNo() {
        return deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public DeviceApplyModel withDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    /**
    * 设备类型，taxDevice：税控设备-税盘，taxControlKey:税控设备-税控钥匙/UKey
    * @return deviceType
    **/
    @ApiModelProperty(value = "设备类型，taxDevice：税控设备-税盘，taxControlKey:税控设备-税控钥匙/UKey")


    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public DeviceApplyModel withId(Long id) {
        this.id = id;
        return this;
    }

    /**
    * 设备id，查询时返回
    * @return id
    **/
    @ApiModelProperty(value = "设备id，查询时返回")


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public DeviceApplyModel withInvoiceType(List<String> invoiceType) {
        this.invoiceType = invoiceType;
        return this;
    }

    public DeviceApplyModel withInvoiceTypeAdd(String invoiceType) {
        if (this.invoiceType == null) {
            this.invoiceType = new ArrayList<String>();
        }
        this.invoiceType.add(invoiceType);
        return this;
    }

    /**
    * 发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）
    * @return invoiceType
    **/
    @ApiModelProperty(value = "发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）")


    public List<String> getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(List<String> invoiceType) {
        this.invoiceType = invoiceType;
    }

    public DeviceApplyModel withIp(String ip) {
        this.ip = ip;
        return this;
    }

    /**
    * ip:服务器模式时输入
    * @return ip
    **/
    @ApiModelProperty(value = "ip:服务器模式时输入")


    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public DeviceApplyModel withNationalTaxPassword(String nationalTaxPassword) {
        this.nationalTaxPassword = nationalTaxPassword;
        return this;
    }

    /**
    * 国税自定义密码
    * @return nationalTaxPassword
    **/
    @ApiModelProperty(value = "国税自定义密码")


    public String getNationalTaxPassword() {
        return nationalTaxPassword;
    }

    public void setNationalTaxPassword(String nationalTaxPassword) {
        this.nationalTaxPassword = nationalTaxPassword;
    }

    public DeviceApplyModel withPhotos(List<String> photos) {
        this.photos = photos;
        return this;
    }

    public DeviceApplyModel withPhotosAdd(String photos) {
        if (this.photos == null) {
            this.photos = new ArrayList<String>();
        }
        this.photos.add(photos);
        return this;
    }

    /**
    * 图片
    * @return photos
    **/
    @ApiModelProperty(value = "图片")


    public List<String> getPhotos() {
        return photos;
    }

    public void setPhotos(List<String> photos) {
        this.photos = photos;
    }

    public DeviceApplyModel withPort(Integer port) {
        this.port = port;
        return this;
    }

    /**
    * 端口：服务器模式时输入
    * @return port
    **/
    @ApiModelProperty(value = "端口：服务器模式时输入")


    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public DeviceApplyModel withServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    /**
    * 直连服务器版涉及到的URL信息 示例：TaxPBserver/kpservices/KpWebService
    * @return serverUrl
    **/
    @ApiModelProperty(value = "直连服务器版涉及到的URL信息 示例：TaxPBserver/kpservices/KpWebService")


    public String getServerUrl() {
        return serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public DeviceApplyModel withService(List<String> service) {
        this.service = service;
        return this;
    }

    public DeviceApplyModel withServiceAdd(String service) {
        if (this.service == null) {
            this.service = new ArrayList<String>();
        }
        this.service.add(service);
        return this;
    }

    /**
    * 支持的服务 （make：开票 ，print：打印，originAccount：底账,assistant：辅助）
    * @return service
    **/
    @ApiModelProperty(value = "支持的服务 （make：开票 ，print：打印，originAccount：底账,assistant：辅助）")


    public List<String> getService() {
        return service;
    }

    public void setService(List<String> service) {
        this.service = service;
    }

    public DeviceApplyModel withShowMachineNoInRemarkFlag(String showMachineNoInRemarkFlag) {
        this.showMachineNoInRemarkFlag = showMachineNoInRemarkFlag;
        return this;
    }

    /**
    * 添加开票机号显示标志：0-在备注里加开票机号  1-不在备注里加开票机号
    * @return showMachineNoInRemarkFlag
    **/
    @ApiModelProperty(value = "添加开票机号显示标志：0-在备注里加开票机号  1-不在备注里加开票机号")


    public String getShowMachineNoInRemarkFlag() {
        return showMachineNoInRemarkFlag;
    }

    public void setShowMachineNoInRemarkFlag(String showMachineNoInRemarkFlag) {
        this.showMachineNoInRemarkFlag = showMachineNoInRemarkFlag;
    }

    public DeviceApplyModel withStatus(Integer status) {
        this.status = status;
        return this;
    }

    /**
    * 税盘状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭 22：作废）
    * @return status
    **/
    @ApiModelProperty(value = "税盘状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭 22：作废）")


    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public DeviceApplyModel withTaxControlKey(String taxControlKey) {
        this.taxControlKey = taxControlKey;
        return this;
    }

    /**
    * 税控钥匙密码
    * @return taxControlKey
    **/
    @ApiModelProperty(value = "税控钥匙密码")


    public String getTaxControlKey() {
        return taxControlKey;
    }

    public void setTaxControlKey(String taxControlKey) {
        this.taxControlKey = taxControlKey;
    }

    public DeviceApplyModel withTaxDeviceDigitalPassword(String taxDeviceDigitalPassword) {
        this.taxDeviceDigitalPassword = taxDeviceDigitalPassword;
        return this;
    }

    /**
    * 税务数字证书密码
    * @return taxDeviceDigitalPassword
    **/
    @ApiModelProperty(value = "税务数字证书密码")


    public String getTaxDeviceDigitalPassword() {
        return taxDeviceDigitalPassword;
    }

    public void setTaxDeviceDigitalPassword(String taxDeviceDigitalPassword) {
        this.taxDeviceDigitalPassword = taxDeviceDigitalPassword;
    }

    public DeviceApplyModel withTaxDeviceMachineNo(String taxDeviceMachineNo) {
        this.taxDeviceMachineNo = taxDeviceMachineNo;
        return this;
    }

    /**
    * 开票机号
    * @return taxDeviceMachineNo
    **/
    @ApiModelProperty(value = "开票机号")


    public String getTaxDeviceMachineNo() {
        return taxDeviceMachineNo;
    }

    public void setTaxDeviceMachineNo(String taxDeviceMachineNo) {
        this.taxDeviceMachineNo = taxDeviceMachineNo;
    }

    public DeviceApplyModel withTaxDevicePassword(String taxDevicePassword) {
        this.taxDevicePassword = taxDevicePassword;
        return this;
    }

    /**
    * 税控盘密码
    * @return taxDevicePassword
    **/
    @ApiModelProperty(value = "税控盘密码")


    public String getTaxDevicePassword() {
        return taxDevicePassword;
    }

    public void setTaxDevicePassword(String taxDevicePassword) {
        this.taxDevicePassword = taxDevicePassword;
    }

    public DeviceApplyModel withTaxDeviceType(Integer taxDeviceType) {
        this.taxDeviceType = taxDeviceType;
        return this;
    }

    /**
    * 1 百望单盘 2 百望服务器  3 航信单盘 4 航信服务器
    * @return taxDeviceType
    **/
    @ApiModelProperty(value = "1 百望单盘 2 百望服务器  3 航信单盘 4 航信服务器")


    public Integer getTaxDeviceType() {
        return taxDeviceType;
    }

    public void setTaxDeviceType(Integer taxDeviceType) {
        this.taxDeviceType = taxDeviceType;
    }

    public DeviceApplyModel withTaxNum(String taxNum) {
        this.taxNum = taxNum;
        return this;
    }

    /**
    * 企业纳税人识别号
    * @return taxNum
    **/
    @ApiModelProperty(value = "企业纳税人识别号")


    public String getTaxNum() {
        return taxNum;
    }

    public void setTaxNum(String taxNum) {
        this.taxNum = taxNum;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeviceApplyModel deviceApplyModel = (DeviceApplyModel) o;
        return Objects.equals(this.companyName, deviceApplyModel.companyName) &&
            Objects.equals(this.confirmInvoiceTimeout, deviceApplyModel.confirmInvoiceTimeout) &&
            Objects.equals(this.createTime, deviceApplyModel.createTime) &&
            Objects.equals(this.deployType, deviceApplyModel.deployType) &&
            Objects.equals(this.deviceNo, deviceApplyModel.deviceNo) &&
            Objects.equals(this.deviceType, deviceApplyModel.deviceType) &&
            Objects.equals(this.id, deviceApplyModel.id) &&
            Objects.equals(this.invoiceType, deviceApplyModel.invoiceType) &&
            Objects.equals(this.ip, deviceApplyModel.ip) &&
            Objects.equals(this.nationalTaxPassword, deviceApplyModel.nationalTaxPassword) &&
            Objects.equals(this.photos, deviceApplyModel.photos) &&
            Objects.equals(this.port, deviceApplyModel.port) &&
            Objects.equals(this.serverUrl, deviceApplyModel.serverUrl) &&
            Objects.equals(this.service, deviceApplyModel.service) &&
            Objects.equals(this.showMachineNoInRemarkFlag, deviceApplyModel.showMachineNoInRemarkFlag) &&
            Objects.equals(this.status, deviceApplyModel.status) &&
            Objects.equals(this.taxControlKey, deviceApplyModel.taxControlKey) &&
            Objects.equals(this.taxDeviceDigitalPassword, deviceApplyModel.taxDeviceDigitalPassword) &&
            Objects.equals(this.taxDeviceMachineNo, deviceApplyModel.taxDeviceMachineNo) &&
            Objects.equals(this.taxDevicePassword, deviceApplyModel.taxDevicePassword) &&
            Objects.equals(this.taxDeviceType, deviceApplyModel.taxDeviceType) &&
            Objects.equals(this.taxNum, deviceApplyModel.taxNum);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyName, confirmInvoiceTimeout, createTime, deployType, deviceNo, deviceType, id, invoiceType, ip, nationalTaxPassword, photos, port, serverUrl, service, showMachineNoInRemarkFlag, status, taxControlKey, taxDeviceDigitalPassword, taxDeviceMachineNo, taxDevicePassword, taxDeviceType, taxNum);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link DeviceApplyModel }.
     */
    public static DeviceApplyModel fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, DeviceApplyModel.class);
    }
}

