package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 企业Request
 */
@ApiModel(description = "企业Request")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class DeviceListRequest   {
    @JsonProperty("companyName")
    private String companyName = null;

    @JsonProperty("page")
    private String page = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private String row = null;

    @JsonProperty("status")
    @Valid
    private List<String> status = null;

    public DeviceListRequest withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    /**
    * 企业名称
    * @return companyName
    **/
    @ApiModelProperty(value = "企业名称")


    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public DeviceListRequest withPage(String page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public DeviceListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public DeviceListRequest withRow(String row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public String getRow() {
        return row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public DeviceListRequest withStatus(List<String> status) {
        this.status = status;
        return this;
    }

    public DeviceListRequest withStatusAdd(String status) {
        if (this.status == null) {
            this.status = new ArrayList<String>();
        }
        this.status.add(status);
        return this;
    }

    /**
    * 设备状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：停用）
    * @return status
    **/
    @ApiModelProperty(value = "设备状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：停用）")


    public List<String> getStatus() {
        return status;
    }

    public void setStatus(List<String> status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeviceListRequest deviceListRequest = (DeviceListRequest) o;
        return Objects.equals(this.companyName, deviceListRequest.companyName) &&
            Objects.equals(this.page, deviceListRequest.page) &&
            Objects.equals(this.rid, deviceListRequest.rid) &&
            Objects.equals(this.row, deviceListRequest.row) &&
            Objects.equals(this.status, deviceListRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyName, page, rid, row, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link DeviceListRequest }.
     */
    public static DeviceListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, DeviceListRequest.class);
    }
}

