package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 企业审核请求对象
 */
@ApiModel(description = "企业审核请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class DoApplyCompanyRequest   {
    @JsonProperty("companyApplyId")
    private Long companyApplyId = null;

    @JsonProperty("operateReason")
    private String operateReason = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("status")
    private Integer status = null;

    public DoApplyCompanyRequest withCompanyApplyId(Long companyApplyId) {
        this.companyApplyId = companyApplyId;
        return this;
    }

    /**
    * 审核记录ID
    * @return companyApplyId
    **/
    @ApiModelProperty(value = "审核记录ID")


    public Long getCompanyApplyId() {
        return companyApplyId;
    }

    public void setCompanyApplyId(Long companyApplyId) {
        this.companyApplyId = companyApplyId;
    }

    public DoApplyCompanyRequest withOperateReason(String operateReason) {
        this.operateReason = operateReason;
        return this;
    }

    /**
    * 审核备注
    * @return operateReason
    **/
    @ApiModelProperty(value = "审核备注")


    public String getOperateReason() {
        return operateReason;
    }

    public void setOperateReason(String operateReason) {
        this.operateReason = operateReason;
    }

    public DoApplyCompanyRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public DoApplyCompanyRequest withStatus(Integer status) {
        this.status = status;
        return this;
    }

    /**
    * 审核状态 2：审核不通过 3：审核通过
    * @return status
    **/
    @ApiModelProperty(value = "审核状态 2：审核不通过 3：审核通过")


    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DoApplyCompanyRequest doApplyCompanyRequest = (DoApplyCompanyRequest) o;
        return Objects.equals(this.companyApplyId, doApplyCompanyRequest.companyApplyId) &&
            Objects.equals(this.operateReason, doApplyCompanyRequest.operateReason) &&
            Objects.equals(this.rid, doApplyCompanyRequest.rid) &&
            Objects.equals(this.status, doApplyCompanyRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyApplyId, operateReason, rid, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link DoApplyCompanyRequest }.
     */
    public static DoApplyCompanyRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, DoApplyCompanyRequest.class);
    }
}

