package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 税盘审核请求对象
 */
@ApiModel(description = "税盘审核请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class DoApplyDeviceRequest   {
    @JsonProperty("deviceId")
    private String deviceId = null;

    @JsonProperty("operateReason")
    private String operateReason = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("status")
    private Integer status = null;

    public DoApplyDeviceRequest withDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    /**
    * 设备ID
    * @return deviceId
    **/
    @ApiModelProperty(value = "设备ID")


    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public DoApplyDeviceRequest withOperateReason(String operateReason) {
        this.operateReason = operateReason;
        return this;
    }

    /**
    * 审核备注
    * @return operateReason
    **/
    @ApiModelProperty(value = "审核备注")


    public String getOperateReason() {
        return operateReason;
    }

    public void setOperateReason(String operateReason) {
        this.operateReason = operateReason;
    }

    public DoApplyDeviceRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public DoApplyDeviceRequest withStatus(Integer status) {
        this.status = status;
        return this;
    }

    /**
    * 审核状态 1：审核通过 2：审核不通过
    * @return status
    **/
    @ApiModelProperty(value = "审核状态 1：审核通过 2：审核不通过")


    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DoApplyDeviceRequest doApplyDeviceRequest = (DoApplyDeviceRequest) o;
        return Objects.equals(this.deviceId, doApplyDeviceRequest.deviceId) &&
            Objects.equals(this.operateReason, doApplyDeviceRequest.operateReason) &&
            Objects.equals(this.rid, doApplyDeviceRequest.rid) &&
            Objects.equals(this.status, doApplyDeviceRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deviceId, operateReason, rid, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link DoApplyDeviceRequest }.
     */
    public static DoApplyDeviceRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, DoApplyDeviceRequest.class);
    }
}

