package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 业务单类型请求参数
 */
@ApiModel(description = "业务单类型请求参数")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class GetBssBusinessTypeRequest   {
    @JsonProperty("businessType")
    private String businessType = null;

    @JsonProperty("page")
    private String page = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private String row = null;

    public GetBssBusinessTypeRequest withBusinessType(String businessType) {
        this.businessType = businessType;
        return this;
    }

    /**
    * 业务单类型
    * @return businessType
    **/
    @ApiModelProperty(value = "业务单类型")


    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public GetBssBusinessTypeRequest withPage(String page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public GetBssBusinessTypeRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public GetBssBusinessTypeRequest withRow(String row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public String getRow() {
        return row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetBssBusinessTypeRequest getBssBusinessTypeRequest = (GetBssBusinessTypeRequest) o;
        return Objects.equals(this.businessType, getBssBusinessTypeRequest.businessType) &&
            Objects.equals(this.page, getBssBusinessTypeRequest.page) &&
            Objects.equals(this.rid, getBssBusinessTypeRequest.rid) &&
            Objects.equals(this.row, getBssBusinessTypeRequest.row);
    }

    @Override
    public int hashCode() {
        return Objects.hash(businessType, page, rid, row);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link GetBssBusinessTypeRequest }.
     */
    public static GetBssBusinessTypeRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, GetBssBusinessTypeRequest.class);
    }
}

