package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 企业审核Request
 */
@ApiModel(description = "企业审核Request")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class GetCompanyApplyListRequest   {
    @JsonProperty("companyCode")
    private String companyCode = null;

    @JsonProperty("companyName")
    private String companyName = null;

    @JsonProperty("page")
    private String page = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private String row = null;

    @JsonProperty("status")
    private Integer status = null;

    @JsonProperty("taxNum")
    private String taxNum = null;

    public GetCompanyApplyListRequest withCompanyCode(String companyCode) {
        this.companyCode = companyCode;
        return this;
    }

    /**
    * 公司编码
    * @return companyCode
    **/
    @ApiModelProperty(value = "公司编码")


    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public GetCompanyApplyListRequest withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    /**
    * 企业名称
    * @return companyName
    **/
    @ApiModelProperty(value = "企业名称")


    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public GetCompanyApplyListRequest withPage(String page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public GetCompanyApplyListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public GetCompanyApplyListRequest withRow(String row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public String getRow() {
        return row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public GetCompanyApplyListRequest withStatus(Integer status) {
        this.status = status;
        return this;
    }

    /**
    * 状态
    * @return status
    **/
    @ApiModelProperty(value = "状态")


    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public GetCompanyApplyListRequest withTaxNum(String taxNum) {
        this.taxNum = taxNum;
        return this;
    }

    /**
    * 税号
    * @return taxNum
    **/
    @ApiModelProperty(value = "税号")


    public String getTaxNum() {
        return taxNum;
    }

    public void setTaxNum(String taxNum) {
        this.taxNum = taxNum;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetCompanyApplyListRequest getCompanyApplyListRequest = (GetCompanyApplyListRequest) o;
        return Objects.equals(this.companyCode, getCompanyApplyListRequest.companyCode) &&
            Objects.equals(this.companyName, getCompanyApplyListRequest.companyName) &&
            Objects.equals(this.page, getCompanyApplyListRequest.page) &&
            Objects.equals(this.rid, getCompanyApplyListRequest.rid) &&
            Objects.equals(this.row, getCompanyApplyListRequest.row) &&
            Objects.equals(this.status, getCompanyApplyListRequest.status) &&
            Objects.equals(this.taxNum, getCompanyApplyListRequest.taxNum);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyCode, companyName, page, rid, row, status, taxNum);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link GetCompanyApplyListRequest }.
     */
    public static GetCompanyApplyListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, GetCompanyApplyListRequest.class);
    }
}

