package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class GetCompanyDetailRequest   {
    @JsonProperty("companyId")
    private String companyId = null;

    @JsonProperty("rid")
    private String rid = null;

    public GetCompanyDetailRequest withCompanyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    /**
    * 企业ID
    * @return companyId
    **/
    @ApiModelProperty(value = "企业ID")


    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public GetCompanyDetailRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetCompanyDetailRequest getCompanyDetailRequest = (GetCompanyDetailRequest) o;
        return Objects.equals(this.companyId, getCompanyDetailRequest.companyId) &&
            Objects.equals(this.rid, getCompanyDetailRequest.rid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyId, rid);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link GetCompanyDetailRequest }.
     */
    public static GetCompanyDetailRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, GetCompanyDetailRequest.class);
    }
}

