package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 企业Request
 */
@ApiModel(description = "企业Request")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class GetCompanyListRequest   {
    @JsonProperty("companyName")
    private String companyName = null;

    @JsonProperty("inspectionServiceFlag")
    private String inspectionServiceFlag = null;

    @JsonProperty("page")
    private String page = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private String row = null;

    @JsonProperty("speedInspectionChannelFlag")
    private String speedInspectionChannelFlag = null;

    @JsonProperty("status")
    private String status = null;

    @JsonProperty("taxNum")
    private String taxNum = null;

    @JsonProperty("traditionAuthenFlag")
    private String traditionAuthenFlag = null;

    public GetCompanyListRequest withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    /**
    * 企业名称
    * @return companyName
    **/
    @ApiModelProperty(value = "企业名称")


    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public GetCompanyListRequest withInspectionServiceFlag(String inspectionServiceFlag) {
        this.inspectionServiceFlag = inspectionServiceFlag;
        return this;
    }

    /**
    * 查验服务状态(1:开启；0:关闭)
    * @return inspectionServiceFlag
    **/
    @ApiModelProperty(value = "查验服务状态(1:开启；0:关闭)")


    public String getInspectionServiceFlag() {
        return inspectionServiceFlag;
    }

    public void setInspectionServiceFlag(String inspectionServiceFlag) {
        this.inspectionServiceFlag = inspectionServiceFlag;
    }

    public GetCompanyListRequest withPage(String page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public GetCompanyListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public GetCompanyListRequest withRow(String row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public String getRow() {
        return row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public GetCompanyListRequest withSpeedInspectionChannelFlag(String speedInspectionChannelFlag) {
        this.speedInspectionChannelFlag = speedInspectionChannelFlag;
        return this;
    }

    /**
    * 极速查验通道状态(1:开启；0:关闭)
    * @return speedInspectionChannelFlag
    **/
    @ApiModelProperty(value = "极速查验通道状态(1:开启；0:关闭)")


    public String getSpeedInspectionChannelFlag() {
        return speedInspectionChannelFlag;
    }

    public void setSpeedInspectionChannelFlag(String speedInspectionChannelFlag) {
        this.speedInspectionChannelFlag = speedInspectionChannelFlag;
    }

    public GetCompanyListRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 启用状态： 1：启用 0：注销
    * @return status
    **/
    @ApiModelProperty(value = "启用状态： 1：启用 0：注销")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public GetCompanyListRequest withTaxNum(String taxNum) {
        this.taxNum = taxNum;
        return this;
    }

    /**
    * 税号
    * @return taxNum
    **/
    @ApiModelProperty(value = "税号")


    public String getTaxNum() {
        return taxNum;
    }

    public void setTaxNum(String taxNum) {
        this.taxNum = taxNum;
    }

    public GetCompanyListRequest withTraditionAuthenFlag(String traditionAuthenFlag) {
        this.traditionAuthenFlag = traditionAuthenFlag;
        return this;
    }

    /**
    * 传统认证管理状态(1:开启；0:关闭)
    * @return traditionAuthenFlag
    **/
    @ApiModelProperty(value = "传统认证管理状态(1:开启；0:关闭)")


    public String getTraditionAuthenFlag() {
        return traditionAuthenFlag;
    }

    public void setTraditionAuthenFlag(String traditionAuthenFlag) {
        this.traditionAuthenFlag = traditionAuthenFlag;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetCompanyListRequest getCompanyListRequest = (GetCompanyListRequest) o;
        return Objects.equals(this.companyName, getCompanyListRequest.companyName) &&
            Objects.equals(this.inspectionServiceFlag, getCompanyListRequest.inspectionServiceFlag) &&
            Objects.equals(this.page, getCompanyListRequest.page) &&
            Objects.equals(this.rid, getCompanyListRequest.rid) &&
            Objects.equals(this.row, getCompanyListRequest.row) &&
            Objects.equals(this.speedInspectionChannelFlag, getCompanyListRequest.speedInspectionChannelFlag) &&
            Objects.equals(this.status, getCompanyListRequest.status) &&
            Objects.equals(this.taxNum, getCompanyListRequest.taxNum) &&
            Objects.equals(this.traditionAuthenFlag, getCompanyListRequest.traditionAuthenFlag);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyName, inspectionServiceFlag, page, rid, row, speedInspectionChannelFlag, status, taxNum, traditionAuthenFlag);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link GetCompanyListRequest }.
     */
    public static GetCompanyListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, GetCompanyListRequest.class);
    }
}

